/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config.compat;

import java.util.Collection;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.config.AbstractConfigScreenFactory;
import org.orecruncher.dsurround.lib.config.Binder;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigOptions;
import org.orecruncher.dsurround.lib.config.ConfigurationData;
import org.orecruncher.dsurround.lib.random.Randomizer;

public class ClothAPIFactory
extends AbstractConfigScreenFactory {
    private static final ResourceLocation[] BACKGROUNDS = new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:textures/block/cobblestone.png"), ResourceLocation.parse((String)"minecraft:textures/block/bedrock.png"), ResourceLocation.parse((String)"minecraft:textures/block/bricks.png"), ResourceLocation.parse((String)"minecraft:textures/block/sandstone.png"), ResourceLocation.parse((String)"minecraft:textures/block/stone.png"), ResourceLocation.parse((String)"minecraft:textures/block/oak_planks.png"), ResourceLocation.parse((String)"minecraft:textures/block/gilded_blackstone.png"), ResourceLocation.parse((String)"minecraft:textures/block/dirt.png")};
    private final ResourceLocation background;

    public ClothAPIFactory(ConfigOptions options, ConfigurationData config) {
        this(options, config, null);
    }

    public ClothAPIFactory(ConfigOptions options, ConfigurationData config, @Nullable ResourceLocation background) {
        super(options, config);
        if (background == null) {
            int idx = Randomizer.current().nextInt(BACKGROUNDS.length);
            this.background = BACKGROUNDS[idx];
        } else {
            this.background = background;
        }
    }

    @Override
    public Screen apply(Screen screen) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle(this.options.transformTitle()).setSavingRunnable(() -> {
            try {
                this.configData.save();
            }
            catch (Throwable t) {
                Library.LOGGER.error(t, "Unable to save configuration", new Object[0]);
            }
        });
        if (this.background != null) {
            builder.setDefaultBackgroundTexture(this.background);
        }
        this.generate(builder, this.configData);
        return builder.build();
    }

    protected void generate(ConfigBuilder builder, Object instance) {
        ConfigCategory root = builder.getOrCreateCategory(this.options.transformTitle());
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        Collection<ConfigElement<?>> properties = this.configData.getSpecification();
        for (ConfigElement<?> prop : properties) {
            ConfigElement.PropertyValue pv;
            FieldBuilder<?, ? extends AbstractConfigListEntry<?>, ?> result;
            if (prop.isHidden()) continue;
            if (prop instanceof ConfigElement.PropertyGroup) {
                ConfigElement.PropertyGroup group = (ConfigElement.PropertyGroup)prop;
                result = this.generate(entryBuilder, group, instance);
                root.addEntry((AbstractConfigListEntry)result.build());
                continue;
            }
            if (!(prop instanceof ConfigElement.PropertyValue) || (result = this.generate(entryBuilder, pv = (ConfigElement.PropertyValue)prop, instance)) == null) continue;
            root.addEntry(result.build());
        }
    }

    protected SubCategoryBuilder generate(ConfigEntryBuilder builder, ConfigElement.PropertyGroup propertyGroup, Object instance) {
        SubCategoryBuilder categoryBuilder = builder.startSubCategory(this.options.transformPropertyGroup(propertyGroup.getLanguageKey())).setTooltip(this.options.transformTooltip(propertyGroup.getTooltip(this.options.getTooltipStyle())).toArray(new Component[0]));
        for (ConfigElement<?> prop : propertyGroup.getChildren()) {
            ConfigElement.PropertyValue pv;
            FieldBuilder<?, ? extends AbstractConfigListEntry<?>, ?> result;
            if (prop.isHidden() || !(prop instanceof ConfigElement.PropertyValue) || (result = this.generate(builder, pv = (ConfigElement.PropertyValue)prop, propertyGroup.getInstance(instance))) == null) continue;
            categoryBuilder.add(result.build());
        }
        return categoryBuilder;
    }

    @Nullable
    protected FieldBuilder<?, ? extends AbstractConfigListEntry<?>, ?> generate(ConfigEntryBuilder builder, ConfigElement.PropertyValue<?> pv, Object instance) {
        Object fieldBuilder = null;
        Component name = this.options.transformProperty(pv.getLanguageKey());
        Component[] tooltip = this.generateToolTip(pv);
        if (pv instanceof ConfigElement.IntegerValue) {
            ConfigElement.IntegerValue v = (ConfigElement.IntegerValue)pv;
            Binder binder = pv.createBinder(instance);
            fieldBuilder = pv.useSlider() ? builder.startIntSlider(name, ((Integer)binder.getValue()).intValue(), v.getMinValue(), v.getMaxValue()).setTooltip(tooltip).setDefaultValue(binder::defaultValue).setSaveConsumer(binder::setValue) : ((IntFieldBuilder)builder.startIntField(name, ((Integer)binder.getValue()).intValue()).setTooltip(tooltip).setDefaultValue((Object)((Integer)binder.defaultValue()))).setMin(v.getMinValue()).setMax(v.getMaxValue()).setSaveConsumer(binder::setValue);
        } else if (pv instanceof ConfigElement.DoubleValue) {
            ConfigElement.DoubleValue v = (ConfigElement.DoubleValue)pv;
            Binder binder = pv.createBinder(instance);
            fieldBuilder = ((DoubleFieldBuilder)builder.startDoubleField(name, ((Double)binder.getValue()).doubleValue()).setTooltip(tooltip).setDefaultValue((Object)((Double)binder.defaultValue()))).setMin(v.getMinValue()).setMax(v.getMaxValue()).setSaveConsumer(binder::setValue);
        } else if (pv instanceof ConfigElement.StringValue) {
            Binder binder = pv.createBinder(instance);
            fieldBuilder = builder.startStrField(name, (String)binder.getValue()).setTooltip(tooltip).setDefaultValue((String)binder.defaultValue()).setSaveConsumer(binder::setValue);
        } else if (pv instanceof ConfigElement.BooleanValue) {
            Binder binder = pv.createBinder(instance);
            fieldBuilder = ((BooleanToggleBuilder)builder.startBooleanToggle(name, ((Boolean)binder.getValue()).booleanValue()).setTooltip(tooltip).setDefaultValue((Object)((Boolean)binder.defaultValue()))).setSaveConsumer(binder::setValue);
        } else if (pv instanceof ConfigElement.EnumValue) {
            ConfigElement.EnumValue v = (ConfigElement.EnumValue)pv;
            Binder binder = pv.createBinder(instance);
            fieldBuilder = new EnumSelectorBuilder(builder.getResetButtonKey(), name, v.getEnumClass(), (Enum)binder.getValue()).setTooltip(tooltip).setDefaultValue((Enum)binder.defaultValue()).setSaveConsumer(binder::setValue);
        }
        if (fieldBuilder != null) {
            fieldBuilder.requireRestart(pv.isAnyRestartRequired());
        }
        return fieldBuilder;
    }

    private Component[] generateToolTip(ConfigElement.PropertyValue<?> pv) {
        return this.generateToolTipCollection(pv).toArray(new Component[0]);
    }
}

