/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.di;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.lib.di.IServiceContainer;
import org.orecruncher.dsurround.lib.di.internal.DependencyContainer;

public final class ContainerManager {
    private static final ContainerManager CONTAINER_MANAGER = new ContainerManager();
    private static final String ROOT_CONTAINER_NAME = "ROOT";
    private static final IServiceContainer ROOT_CONTAINER = new DependencyContainer("ROOT", CONTAINER_MANAGER);
    private final Map<String, IServiceContainer> containers = new HashMap<String, IServiceContainer>();

    private ContainerManager() {
    }

    public static Stream<String> dumpRegistrations() {
        return ROOT_CONTAINER.dumpRegistrations();
    }

    @NotNull
    public static IServiceContainer getRootContainer() {
        return ROOT_CONTAINER;
    }

    @NotNull
    public static <T> T resolve(@NotNull Class<T> clazz) {
        return ROOT_CONTAINER.resolve(clazz);
    }

    public void registerContainer(@NotNull IServiceContainer container) {
        Preconditions.checkNotNull((Object)container);
        this.validiateContainerName(container.getName());
        this.containers.put(container.getName(), container);
    }

    private void validiateContainerName(String containerName) {
        Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkArgument((containerName.length() > 3 ? 1 : 0) != 0, (Object)"Container name must be > 3 characters");
        Preconditions.checkArgument((boolean)ROOT_CONTAINER_NAME.equalsIgnoreCase(containerName), (Object)String.format("Container name cannot be '%s'", ROOT_CONTAINER_NAME));
        Preconditions.checkArgument((boolean)this.containers.containsKey(containerName), (Object)"A container with that name already exists");
    }

    static {
        ContainerManager.CONTAINER_MANAGER.containers.put(ROOT_CONTAINER_NAME, ROOT_CONTAINER);
    }
}

