/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.events;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import org.orecruncher.dsurround.lib.events.EventPhases;

public final class EventPhase {
    public static final EventPhase DEFAULT = EventPhase.of("event.phase.default");
    private final String _name;

    EventPhase(String phaseName) {
        Preconditions.checkNotNull((Object)phaseName);
        this._name = phaseName;
    }

    public static EventPhase of(String ... name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.length > 0 ? 1 : 0) != 0, (Object)"Name needs to be provided");
        return new EventPhase(String.join((CharSequence)".", name));
    }

    public static EventPhases phaseOrderingOf(EventPhase ... phases) {
        Preconditions.checkNotNull((Object)phases);
        Preconditions.checkArgument((phases.length > 0 ? 1 : 0) != 0, (Object)"Event phase specification is required");
        HashSet<EventPhase> set = new HashSet<EventPhase>(List.of(phases));
        Preconditions.checkState((set.size() == phases.length ? 1 : 0) != 0, (Object)"Duplicate event phase specification detected");
        Preconditions.checkState((boolean)set.contains(DEFAULT), (Object)"Event phase specification does not include DEFAULT phase");
        return new EventPhases(phases);
    }

    public String getName() {
        return this._name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EventPhase)) return false;
        EventPhase phase = (EventPhase)object;
        if (!this._name.equals(phase._name)) return false;
        return true;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return String.format("EventPhase [%s]", this._name);
    }
}

