/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.gui;

import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import org.orecruncher.dsurround.lib.gui.ColorPalette;

public class ColorGradient {
    private final int sRed;
    private final int sGreen;
    private final int sBlue;
    private final int eRed;
    private final int eGreen;
    private final int eBlue;
    private final float scale;

    public ColorGradient(TextColor start, TextColor end, float scale) {
        this.scale = scale;
        int color = start.getValue();
        this.sRed = ColorPalette.getRed(color);
        this.sGreen = ColorPalette.getGreen(color);
        this.sBlue = ColorPalette.getBlue(color);
        color = end.getValue();
        this.eRed = ColorPalette.getRed(color);
        this.eGreen = ColorPalette.getGreen(color);
        this.eBlue = ColorPalette.getBlue(color);
    }

    public int getRGBColor(float delta) {
        float ratio = delta / this.scale;
        int red = (int)Mth.lerp((float)ratio, (float)this.sRed, (float)this.eRed);
        int green = (int)Mth.lerp((float)ratio, (float)this.sGreen, (float)this.eGreen);
        int blue = (int)Mth.lerp((float)ratio, (float)this.sBlue, (float)this.eBlue);
        return ColorPalette.toRGB(red, green, blue);
    }

    public TextColor getTextColor(float delta) {
        return TextColor.fromRgb((int)this.getRGBColor(delta));
    }
}

