/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.gui;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public final class ColorPalette {
    public static final TextColor CURSEFORGE = ColorPalette.of("#f16436");
    public static final TextColor MODRINTH = ColorPalette.of("#1bd96a");
    public static final TextColor MC_BLACK = ColorPalette.of(ChatFormatting.BLACK);
    public static final TextColor MC_DARKBLUE = ColorPalette.of(ChatFormatting.DARK_BLUE);
    public static final TextColor MC_DARKGREEN = ColorPalette.of(ChatFormatting.DARK_GREEN);
    public static final TextColor MC_DARKAQUA = ColorPalette.of(ChatFormatting.DARK_AQUA);
    public static final TextColor MC_DARKRED = ColorPalette.of(ChatFormatting.DARK_RED);
    public static final TextColor MC_DARKPURPLE = ColorPalette.of(ChatFormatting.DARK_PURPLE);
    public static final TextColor MC_GOLD = ColorPalette.of(ChatFormatting.GOLD);
    public static final TextColor MC_GRAY = ColorPalette.of(ChatFormatting.GRAY);
    public static final TextColor MC_DARKGRAY = ColorPalette.of(ChatFormatting.DARK_GRAY);
    public static final TextColor MC_BLUE = ColorPalette.of(ChatFormatting.BLUE);
    public static final TextColor MC_GREEN = ColorPalette.of(ChatFormatting.GREEN);
    public static final TextColor MC_AQUA = ColorPalette.of(ChatFormatting.AQUA);
    public static final TextColor MC_RED = ColorPalette.of(ChatFormatting.RED);
    public static final TextColor MC_LIGHTPURPLE = ColorPalette.of(ChatFormatting.LIGHT_PURPLE);
    public static final TextColor MC_YELLOW = ColorPalette.of(ChatFormatting.YELLOW);
    public static final TextColor MC_WHITE = ColorPalette.of(ChatFormatting.WHITE);
    public static final TextColor CRIMSON = ColorPalette.of("#8D230F");
    public static final TextColor RED = ColorPalette.of(255, 0, 0);
    public static final TextColor ORANGE = ColorPalette.of(255, 127, 0);
    public static final TextColor YELLOW = ColorPalette.of(255, 255, 0);
    public static final TextColor LGREEN = ColorPalette.of(127, 255, 0);
    public static final TextColor GREEN = ColorPalette.of(0, 255, 0);
    public static final TextColor TURQUOISE = ColorPalette.of(0, 255, 127);
    public static final TextColor CYAN = ColorPalette.of(0, 255, 255);
    public static final TextColor AQUAMARINE = ColorPalette.of(127, 255, 212);
    public static final TextColor BLUE = ColorPalette.of(0, 0, 255);
    public static final TextColor VIOLET = ColorPalette.of(127, 0, 255);
    public static final TextColor MAGENTA = ColorPalette.of(255, 0, 255);
    public static final TextColor RASPBERRY = ColorPalette.of(255, 0, 127);
    public static final TextColor BLACK = ColorPalette.of(0, 0, 0);
    public static final TextColor WHITE = ColorPalette.of(255, 255, 255);
    public static final TextColor PURPLE = ColorPalette.of(80, 0, 80);
    public static final TextColor INDIGO = ColorPalette.of(75, 0, 130);
    public static final TextColor NAVY = ColorPalette.of(0, 0, 128);
    public static final TextColor TAN = ColorPalette.of(210, 180, 140);
    public static final TextColor GOLD = ColorPalette.of(255, 215, 0);
    public static final TextColor GRAY = ColorPalette.of(128, 128, 128);
    public static final TextColor LGRAY = ColorPalette.of(192, 192, 192);
    public static final TextColor SLATEGRAY = ColorPalette.of(112, 128, 144);
    public static final TextColor DARKSLATEGRAY = ColorPalette.of(47, 79, 79);
    public static final TextColor SILVER_SAND = ColorPalette.of(191, 193, 194);
    public static final TextColor SUN_GLOW = ColorPalette.of(255, 204, 51);
    public static final TextColor CORN_FLOWER_BLUE = ColorPalette.of(100, 149, 237);
    public static final TextColor APRICOT = ColorPalette.of(251, 206, 177);
    public static final TextColor KEY_LIME = ColorPalette.of(232, 244, 140);
    public static final TextColor BRIGHT_CERULEAN = ColorPalette.of(29, 172, 214);
    public static final TextColor BURNT_UMBER = ColorPalette.of(110, 38, 14);
    public static final TextColor GOLDENROD = ColorPalette.of(218, 165, 32);
    public static final TextColor WHEAT = ColorPalette.of(245, 222, 179);
    public static final TextColor PUMPKIN_ORANGE = ColorPalette.of(255, 117, 24);
    public static final TextColor DESERT = ColorPalette.of(250, 213, 165);
    public static final TextColor CORNSILK = ColorPalette.of(255, 248, 220);
    public static final TextColor BRASS = ColorPalette.of(225, 193, 110);
    public static final TextColor ECRU = ColorPalette.of(194, 178, 128);
    public static final TextColor SEASHELL = ColorPalette.of(255, 245, 238);
    public static final TextColor ORCHID = ColorPalette.of(218, 112, 214);
    public static final TextColor PALE_BROWN = ColorPalette.of(152, 118, 84);
    public static final TextColor DARK_VIOLET = ColorPalette.of(148, 0, 211);
    public static final TextColor ANTIQUE_WHITE = ColorPalette.of(250, 235, 215);
    public static final TextColor PEARLY_PURPLE = ColorPalette.of(183, 104, 162);
    public static final TextColor FRESH_AIR = ColorPalette.of(166, 231, 255);
    public static final TextColor HOT_PINK = ColorPalette.of("#ff69b4");
    public static final TextColor LEMON = ColorPalette.of(254, 251, 1);
    public static final TextColor ELECTRIC_GREEN = ColorPalette.of(0, 237, 1);

    public static int getRed(int rgb) {
        return FastColor.ARGB32.red((int)rgb);
    }

    public static int getGreen(int rgb) {
        return FastColor.ARGB32.green((int)rgb);
    }

    public static int getBlue(int rgb) {
        return FastColor.ARGB32.blue((int)rgb);
    }

    private static TextColor of(ChatFormatting formatColor) {
        return TextColor.fromLegacyFormat((ChatFormatting)formatColor);
    }

    private static TextColor of(String formatColor) {
        return (TextColor)TextColor.parseColor((String)formatColor).getOrThrow();
    }

    private static TextColor of(int rgb) {
        return TextColor.fromRgb((int)rgb);
    }

    private static TextColor of(int red, int green, int blue) {
        return ColorPalette.of(ColorPalette.toRGB(red, green, blue));
    }

    static int toRGB(int red, int green, int blue) {
        return FastColor.ARGB32.color((int)red, (int)green, (int)blue);
    }

    public static TextColor lerp(float scale, TextColor start, TextColor end) {
        int startRed = ColorPalette.getRed(start.getValue());
        int startGreen = ColorPalette.getGreen(start.getValue());
        int startBlue = ColorPalette.getBlue(start.getValue());
        int endRed = ColorPalette.getRed(end.getValue());
        int endGreen = ColorPalette.getGreen(end.getValue());
        int endBlue = ColorPalette.getBlue(end.getValue());
        int red = Mth.lerpInt((float)scale, (int)startRed, (int)endRed);
        int green = Mth.lerpInt((float)scale, (int)startGreen, (int)endGreen);
        int blue = Mth.lerpInt((float)scale, (int)startBlue, (int)endBlue);
        return ColorPalette.of(red, green, blue);
    }
}

