/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.gui;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.GameUtils;

public class GuiHelpers {
    private static final String ELLIPSES = "...";

    public static Collection<Component> getTrimmedTextCollection(String key, int width, Style style) {
        MutableComponent text = Component.translatable((String)key);
        return GuiHelpers.getTrimmedTextCollection((Component)text, width, style);
    }

    public static Collection<Component> getTrimmedTextCollection(Component text, int width, Style style) {
        ArrayList<Component> result = new ArrayList<Component>();
        StringSplitter textHandler = GameUtils.getTextHandler();
        textHandler.splitLines((FormattedText)text, width, style).forEach(line -> result.add((Component)Component.literal((String)line.getString()).withStyle(style)));
        return result;
    }

    public static FormattedText getTrimmedText(String key, int width, ChatFormatting ... formatting) {
        Font fr = GameUtils.getTextRenderer();
        StringSplitter cm = GameUtils.getTextHandler();
        Style style = GuiHelpers.prefixHelper(formatting);
        MutableComponent text = Component.translatable((String)key);
        if (fr.width((FormattedText)text) > width) {
            int ellipsesWidth = fr.width(ELLIPSES);
            int trueWidth = width - ellipsesWidth;
            FormattedText str = cm.headByWidth((FormattedText)text, trueWidth, style);
            return Component.literal((String)(str.getString() + ELLIPSES));
        }
        FormattedText str = cm.headByWidth((FormattedText)text, width, style);
        return Component.literal((String)str.getString());
    }

    private static Style prefixHelper(@Nullable ChatFormatting[] formatting) {
        Style style = formatting != null && formatting.length > 0 ? Style.EMPTY.applyFormats(formatting) : Style.EMPTY;
        return style;
    }
}

