/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.gui;

import java.util.List;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public abstract class SliderControl
extends AbstractSliderButton {
    protected final double step;
    protected final double min;
    protected final List<FormattedCharSequence> toolTip;
    protected double max;

    public SliderControl(int x, int y, int width, int height, double minValue, double maxValue, float valueStep, double currentValue, List<FormattedCharSequence> toolTip) {
        super(x, y, width, height, (Component)Component.empty(), SliderControl.getRatio(currentValue, minValue, maxValue, valueStep));
        this.min = minValue;
        this.max = maxValue;
        this.step = valueStep;
        this.toolTip = toolTip;
    }

    private static double getRatio(double value, double min, double max, double step) {
        double adjusted = SliderControl.adjust(value, min, max, step);
        return Mth.clamp((double)((adjusted - min) / (max - min)), (double)0.0, (double)1.0);
    }

    private static double getValue(double ratio, double min, double max, double step) {
        double value = Mth.clamp((double)ratio, (double)0.0, (double)1.0);
        return SliderControl.adjust(Mth.lerp((double)value, (double)min, (double)max), min, max, step);
    }

    private static double adjust(double value, double min, double max, double step) {
        if (step > 0.0) {
            value = step * (double)Math.round(value / step);
        }
        return Mth.clamp((double)value, (double)min, (double)max);
    }

    public double getValue() {
        return SliderControl.getValue(this.value, this.min, this.max, this.step);
    }

    protected abstract void updateMessage();

    protected abstract void applyValue();
}

