/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.math;

import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;

public class MathStuff {
    public static final double PHI = 0.5 + Math.sqrt(5.0) / 2.0;
    public static final float PHI_F = (float)PHI;
    public static final double ANGLE = PHI * Math.PI * 2.0;
    public static final float ANGLE_F = (float)ANGLE;
    public static final float PI_F = (float)Math.PI;
    public static final float E_F = (float)Math.E;

    public static double log(double value) {
        return value < 0.03 ? Math.log(value) : 6.0 * (value - 1.0) / (value + 1.0 + 4.0 * Math.sqrt(value));
    }

    public static Vec3 normalize(Vec3 vec) {
        double len = Math.sqrt(vec.x * vec.x + vec.y * vec.y * (vec.z * vec.z));
        return new Vec3(vec.x / len, vec.y / len, vec.z / len);
    }

    public static Vec3 randomPoint(int minRange, int maxRange) {
        IRandomizer rand = Randomizer.current();
        double x = rand.nextDouble() - 0.5;
        double y = rand.nextDouble() - 0.5;
        double z = rand.nextDouble() - 0.5;
        Vec3 vec = new Vec3(x, y, z).normalize();
        int range = maxRange - minRange;
        double magnitude = range <= 0 ? (double)minRange : (double)minRange + rand.nextDouble() * (double)range;
        return vec.scale(magnitude);
    }

    public static Vec3 reflection(Vec3 vector, Vec3 surfaceNormal) {
        double dot2 = vector.dot(surfaceNormal) * 2.0;
        double x = vector.x - dot2 * surfaceNormal.x;
        double y = vector.y - dot2 * surfaceNormal.y;
        double z = vector.z - dot2 * surfaceNormal.z;
        return new Vec3(x, y, z);
    }

    public static Vec3 addScaled(Vec3 base, Vec3 addened, double scale) {
        return base.add(addened.x() * scale, addened.y() * scale, addened.z() * scale);
    }

    public static double pow(double a, double b) {
        long tmp = Double.doubleToRawLongBits(a);
        long tmp2 = (long)(b * (double)(tmp - 4606921280493453312L)) + 4606921280493453312L;
        return Double.longBitsToDouble(tmp2);
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static float clamp1(float num) {
        return num <= 0.0f ? 0.0f : Math.min(num, 1.0f);
    }

    public static double clamp1(double num) {
        return num <= 0.0 ? 0.0 : Math.min(num, 1.0);
    }
}

