/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.math;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.math.ReusableRaycastContext;

public class ReusableRaycastIterator
implements Iterator<BlockHitResult> {
    private final ReusableRaycastContext traceContext;
    private final BlockPos targetBlock;
    private final Vec3 normal;
    @Nullable
    private BlockHitResult hitResult;

    public ReusableRaycastIterator(ReusableRaycastContext traceContext) {
        this.traceContext = traceContext;
        this.targetBlock = BlockPos.containing((Position)traceContext.getEnd());
        this.normal = traceContext.getStart().vectorTo(traceContext.getEnd()).normalize();
        this.doTrace();
    }

    private void doTrace() {
        this.hitResult = this.hitResult != null && this.hitResult.getBlockPos().equals((Object)this.targetBlock) ? null : this.traceContext.trace();
    }

    @Override
    public boolean hasNext() {
        return this.hitResult != null && this.hitResult.getType() != HitResult.Type.MISS;
    }

    @Override
    public BlockHitResult next() {
        if (this.hitResult == null || this.hitResult.getType() == HitResult.Type.MISS) {
            throw new IllegalStateException("No more blocks in trace");
        }
        BlockHitResult result = this.hitResult;
        this.traceContext.setStart(this.hitResult.getLocation().add(this.normal));
        this.doTrace();
        return result;
    }
}

