/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.random;

import java.util.random.RandomGenerator;
import java.util.random.RandomGeneratorFactory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.lib.random.IRandomizer;

final class JavaRandomizer
implements IRandomizer {
    public static final String XOROSHIRO_128_PLUS_PLUS = "Xoroshiro128PlusPlus";
    private final RandomGenerator generator;

    public JavaRandomizer(String algorithm) {
        this.generator = RandomGeneratorFactory.of(algorithm).create();
    }

    public JavaRandomizer(String algorithm, long seed) {
        this.generator = RandomGeneratorFactory.of(algorithm).create(seed);
    }

    @NotNull
    public RandomSource fork() {
        return new JavaRandomizer(XOROSHIRO_128_PLUS_PLUS, this.nextLong());
    }

    @NotNull
    public PositionalRandomFactory forkPositional() {
        return new LegacyRandomSource.LegacyPositionalRandomFactory(this.nextLong());
    }

    public void setSeed(long l) {
    }

    public int nextInt() {
        return this.generator.nextInt();
    }

    public int nextInt(int bound) {
        return this.generator.nextInt(bound);
    }

    public boolean nextBoolean() {
        return this.generator.nextBoolean();
    }

    public double nextDouble() {
        return this.generator.nextDouble();
    }

    public float nextFloat() {
        return this.generator.nextFloat();
    }

    public double nextGaussian() {
        return this.generator.nextGaussian();
    }

    public long nextLong() {
        return this.generator.nextLong();
    }
}

