/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.random;

import java.util.function.Supplier;
import java.util.random.RandomGeneratorFactory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.JavaRandomizer;
import org.orecruncher.dsurround.lib.random.MinecraftRandomizer;

public final class Randomizer
implements IRandomizer {
    private static final Supplier<IRandomizer> DEFAULT_RANDOMIZER = Randomizer::getRandomizer;
    private static final ThreadLocal<IRandomizer> THREAD_LOCAL = ThreadLocal.withInitial(DEFAULT_RANDOMIZER);
    private static final IRandomizer SHARED = new Randomizer();

    public static IRandomizer current() {
        return SHARED;
    }

    private Randomizer() {
    }

    @NotNull
    public RandomSource fork() {
        return THREAD_LOCAL.get().fork();
    }

    @NotNull
    public PositionalRandomFactory forkPositional() {
        return THREAD_LOCAL.get().forkPositional();
    }

    public void setSeed(long l) {
        THREAD_LOCAL.get().setSeed(l);
    }

    public int nextInt() {
        return THREAD_LOCAL.get().nextInt();
    }

    public int nextInt(int i) {
        return THREAD_LOCAL.get().nextInt(i);
    }

    public long nextLong() {
        return THREAD_LOCAL.get().nextLong();
    }

    public boolean nextBoolean() {
        return THREAD_LOCAL.get().nextBoolean();
    }

    public float nextFloat() {
        return THREAD_LOCAL.get().nextFloat();
    }

    public double nextDouble() {
        return THREAD_LOCAL.get().nextDouble();
    }

    public double nextGaussian() {
        return THREAD_LOCAL.get().nextGaussian();
    }

    private static IRandomizer getRandomizer() {
        try {
            Library.LOGGER.info("Creating RandomGenerator '%s'", "Xoroshiro128PlusPlus");
            return new JavaRandomizer("Xoroshiro128PlusPlus");
        }
        catch (Exception ex) {
            Library.LOGGER.error(ex, "Unable to create randomizer!", new Object[0]);
            Library.LOGGER.info("RandomGenerator factories available:", new Object[0]);
            RandomGeneratorFactory.all().map(RandomGeneratorFactory::name).sorted().forEach(x$0 -> Library.LOGGER.info((String)x$0, new Object[0]));
            Library.LOGGER.info("Falling back to Minecraft randomizer", new Object[0]);
            return new MinecraftRandomizer();
        }
    }
}

