/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.registry;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.orecruncher.dsurround.lib.GameUtils;

public class RegistryUtils {
    public static <T> Optional<Registry<T>> getRegistry(ResourceKey<? extends Registry<T>> registryKey) {
        return GameUtils.getRegistryManager().flatMap(rm -> rm.registry(registryKey)).or(() -> BuiltInRegistries.REGISTRY.getOptional(registryKey.location()));
    }

    public static <T> Optional<Holder.Reference<T>> getRegistryEntry(ResourceKey<Registry<T>> registryKey, T instance) {
        return RegistryUtils.getRegistry(registryKey).flatMap(r -> r.getHolder(r.getId(instance)));
    }

    public static <T> Optional<Holder.Reference<T>> getRegistryEntry(ResourceKey<Registry<T>> registryKey, ResourceLocation location) {
        ResourceKey rk = ResourceKey.create(registryKey, (ResourceLocation)location);
        return RegistryUtils.getRegistry(registryKey).flatMap(registry -> registry.getHolder(rk));
    }
}

