/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.resources.IResourceFinder;

public abstract class AbstractResourceFinder
implements IResourceFinder {
    protected final IModLog logger;

    protected AbstractResourceFinder(IModLog logger) {
        this.logger = ModLog.createChild(logger, "ResourceFinder");
    }

    protected <T> Optional<T> decode(ResourceLocation location, String content, Codec<T> decoder) {
        this.logger.debug(4, "[%s] - Decoding resource", location);
        Optional<T> result = CodecExtensions.deserialize(content, decoder);
        if (this.logger.isTracing(4)) {
            if (result.isPresent()) {
                this.logger.debug(4, "[%s] - Content successfully decoded", location);
            } else {
                this.logger.debug(4, "[%s] - No content", location);
            }
        }
        return result;
    }
}

