/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.AbstractResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;

public class ClientResourceFinder
extends AbstractResourceFinder {
    private final ResourceManager resourceManager;

    protected ClientResourceFinder(IModLog logger, ResourceManager resourceManager) {
        super(logger);
        this.resourceManager = resourceManager;
    }

    @Override
    public <T> Collection<DiscoveredResource<T>> find(Codec<T> codec, String assetPath) {
        HashMap<ResourceLocation, Collection> results = new HashMap<ResourceLocation, Collection>();
        this.logger.debug(4, "[%s] - Locating assets", assetPath);
        Map assets = this.resourceManager.listResourceStacks(assetPath, location -> true);
        if (assets.isEmpty()) {
            this.logger.debug(4, "[%s] - No assets found", assetPath);
            return ImmutableList.of();
        }
        this.logger.debug(4, "[%s] - %d entries found", assetPath, assets.size());
        for (Map.Entry kvp : assets.entrySet()) {
            this.logger.debug(4, "[%s] - Processing %s", assetPath, kvp.getKey());
            Collection resultList = results.computeIfAbsent((ResourceLocation)kvp.getKey(), i -> new ObjectArray());
            for (Resource resource : (List)kvp.getValue()) {
                try {
                    InputStream inputStream = resource.open();
                    try {
                        byte[] assetBytes = inputStream.readAllBytes();
                        String assetString = new String(assetBytes, Charset.defaultCharset());
                        Optional<Object> entity = this.decode((ResourceLocation)kvp.getKey(), assetString, codec);
                        entity.ifPresent(e -> resultList.add(new DiscoveredResource<Object>(((ResourceLocation)kvp.getKey()).getNamespace(), e)));
                        this.logger.debug(4, "[%s] - Completed decode of %s", assetPath, kvp.getKey());
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Throwable t) {
                    this.logger.error(t, "[%s] - Unable to read resource stream for path %s", assetPath, kvp.getKey());
                }
            }
        }
        return results.values().stream().flatMap(Collection::stream).toList();
    }
}

