/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.MinecraftServerType;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.system.IStopwatch;
import org.orecruncher.dsurround.lib.system.ISystemClock;

public class ClientTagLoader {
    private final IModLog logger;
    private final ISystemClock systemClock;
    private final Map<TagKey<?>, TagData<?>> tagCache = new Reference2ObjectOpenHashMap(256);
    private MinecraftServerType serverType;
    @NotNull
    private ResourceUtilities resourceUtilities;

    public ClientTagLoader(@NotNull ResourceUtilities resourceUtilities, IModLog logger, ISystemClock systemClock) {
        this.resourceUtilities = resourceUtilities;
        this.logger = ModLog.createChild(logger, "ClientTagLoader");
        this.systemClock = systemClock;
        this.serverType = MinecraftServerType.VANILLA;
    }

    public Collection<ResourceLocation> getMembers(TagKey<?> tagKey) {
        return this.getTagData(tagKey, new HashSet()).members();
    }

    public <T> Collection<ResourceLocation> getCompleteIds(TagKey<T> tagKey) {
        return this.getTagData(tagKey, new HashSet()).members();
    }

    public void clear() {
        this.logger.debug(4, "Clearing client tag loader", new Object[0]);
        this.tagCache.clear();
    }

    public void setResourceUtilities(ResourceUtilities resourceUtilities) {
        if (this.resourceUtilities != resourceUtilities) {
            this.resourceUtilities = resourceUtilities;
            this.clear();
        }
    }

    public void setServerType(MinecraftServerType serverType) {
        if (this.serverType != serverType) {
            this.clear();
            this.serverType = serverType;
        }
    }

    private <T> TagData<T> getTagData(TagKey<T> tagKey, Set<TagKey<?>> visited) {
        TagData<Object> data = this.tagCache.get(tagKey);
        if (data == null) {
            if (visited.contains(tagKey)) {
                this.logger.debug(4, "%s - Previously encountered; skipping", tagKey);
                return TagData.empty();
            }
            visited.add(tagKey);
            this.logger.debug(4, "%s - Loading tag files", tagKey);
            data = this.loadTagData(tagKey, visited);
            this.logger.debug(4, "%s - Caching results; total of %d members", tagKey, data.members().size());
            this.tagCache.put(tagKey, data);
        } else {
            this.logger.debug(4, "%s - Already in cache; total of %d members", tagKey, data.members().size());
        }
        return TagData.cast(data);
    }

    private <T> TagData<T> loadTagData(final TagKey<T> tagKey, final Set<TagKey<?>> visited) {
        HashSet completeIds = new HashSet();
        Optional<Iterable<Holder<T>>> holderSet = this.shortcutLookup(tagKey);
        if (holderSet.isPresent()) {
            Iterable<Holder<T>> data = holderSet.get();
            this.logger.debug(4, "%s - Shortcut lookup", tagKey);
            for (Holder<T> holder : data) {
                Optional key = holder.unwrapKey();
                key.ifPresent(tResourceKey -> completeIds.add(tResourceKey.location()));
            }
        } else {
            HashSet entries = new HashSet();
            IStopwatch stopwatch = this.systemClock.getStopwatch();
            Collection<TagFile> tagFiles = this.resourceUtilities.findClientTagFiles(tagKey);
            this.logger.debug(4, "[%s] Find client tags took %dmillis", tagKey, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            tagFiles.forEach(tf -> entries.addAll(tf.entries()));
            if (!entries.isEmpty()) {
                this.logger.debug(4, "%s - %d entries found", tagKey, entries.size());
                TagEntry.Lookup<ResourceLocation> lookup = new TagEntry.Lookup<ResourceLocation>(){

                    @NotNull
                    public ResourceLocation element(@NotNull ResourceLocation id) {
                        return id;
                    }

                    @Nullable
                    public Collection<ResourceLocation> tag(@NotNull ResourceLocation id) {
                        TagKey tag = TagKey.create((ResourceKey)tagKey.registry(), (ResourceLocation)id);
                        ClientTagLoader.this.logger.debug(4, "%s - Recurse %s", tagKey, tag);
                        Set<ResourceLocation> result = ClientTagLoader.this.getTagData(tag, visited).members();
                        ClientTagLoader.this.logger.debug(4, "%s - Completed recursion %s", tagKey, tag);
                        return result;
                    }
                };
                for (TagEntry tagEntry : entries) {
                    tagEntry.build((TagEntry.Lookup)lookup, completeIds::add);
                }
            }
        }
        if (completeIds.isEmpty()) {
            this.logger.debug(4, "%s - Tag is empty", tagKey);
            return TagData.empty();
        }
        this.logger.debug(4, "%s - %d direct instances", tagKey, completeIds.size());
        return new TagData((Set<ResourceLocation>)ImmutableSet.copyOf(completeIds));
    }

    private <T> Optional<Iterable<Holder<T>>> shortcutLookup(TagKey<T> tagKey) {
        String namespace = tagKey.location().getNamespace();
        if (namespace.equals("dsurround")) {
            return Optional.empty();
        }
        if (this.serverType.isModded() || "minecraft".equals(namespace)) {
            Optional registry = RegistryUtils.getRegistry(tagKey.registry());
            if (registry.isEmpty()) {
                return Optional.empty();
            }
            Optional holderSet = registry.get().getTag(tagKey);
            if (holderSet.isPresent()) {
                return Optional.of((Iterable)holderSet.get());
            }
            return Optional.of(ImmutableList.of());
        }
        return Optional.empty();
    }

    private record TagData<T>(Set<ResourceLocation> members) {
        private static final TagData<?> EMPTY = new TagData((Set<ResourceLocation>)ImmutableSet.of());

        public static <T> TagData<T> empty() {
            return TagData.cast(EMPTY);
        }

        public static <T> TagData<T> cast(TagData<?> tagData) {
            return tagData;
        }
    }
}

