/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.mojang.serialization.Codec;
import java.util.Collection;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.resources.ClientResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.DiskResourceFinder;
import org.orecruncher.dsurround.lib.resources.ModConfigResourceFinder;
import org.orecruncher.dsurround.lib.resources.ServerResourceFinder;

public final class ResourceUtilities {
    private final ModConfigResourceFinder modConfigHelper;
    private final DiskResourceFinder diskResourceHelper;
    private final ClientResourceFinder resourceFinder;
    private final ServerResourceFinder packResourceFinder;

    ResourceUtilities(IModLog modLog, IMinecraftDirectories minecraftDirectories, ResourceManager resourceManager) {
        this.modConfigHelper = new ModConfigResourceFinder(modLog, resourceManager, "dsconfigs");
        this.diskResourceHelper = new DiskResourceFinder(modLog, minecraftDirectories.getModDataDirectory());
        this.resourceFinder = new ClientResourceFinder(modLog, resourceManager);
        this.packResourceFinder = new ServerResourceFinder(modLog);
    }

    public <T> Collection<DiscoveredResource<T>> findModResources(Codec<T> codec, String assetPath) {
        ObjectArray<DiscoveredResource<DiscoveredResource<T>>> result = new ObjectArray<DiscoveredResource<DiscoveredResource<T>>>();
        result.addAll((Collection<DiscoveredResource<DiscoveredResource<T>>>)this.modConfigHelper.find(codec, assetPath));
        result.addAll((Collection<DiscoveredResource<DiscoveredResource<T>>>)this.diskResourceHelper.find(codec, assetPath));
        return result;
    }

    public <T> Collection<DiscoveredResource<T>> findResources(Codec<T> codec, String assetPath) {
        return this.resourceFinder.find(codec, assetPath);
    }

    public Collection<TagFile> findClientTagFiles(TagKey<?> tagKey) {
        ObjectArray result = new ObjectArray();
        String tagDir = Registries.tagsDirPath((ResourceKey)tagKey.registry());
        String tagFolder = "%s/%s".formatted(tagDir, tagKey.location().getPath());
        String tagFolderPack = "%s:%s".formatted(tagKey.location().getNamespace(), tagFolder);
        result.addAll(this.packResourceFinder.find(TagFile.CODEC, tagFolderPack));
        result.addAll(this.modConfigHelper.find(TagFile.CODEC, tagFolder));
        result.addAll(this.diskResourceHelper.find(TagFile.CODEC, tagFolder));
        return result.stream().map(DiscoveredResource::resourceContent).toList();
    }

    public static ResourceUtilities createForCurrentState() {
        return ResourceUtilities.createForResourceManager(GameUtils.getMC().getResourceManager());
    }

    public static ResourceUtilities createForResourceManager(ResourceManager resourceManager) {
        IModLog logger = ContainerManager.resolve(IModLog.class);
        IMinecraftDirectories directories = ContainerManager.resolve(IMinecraftDirectories.class);
        return new ResourceUtilities(logger, directories, resourceManager);
    }
}

