/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.scanner.CuboidPointIterator;
import org.orecruncher.dsurround.lib.scanner.IPointIterator;

public class ComplementsPointIterator
implements IPointIterator {
    protected CuboidPointIterator[] segments = new CuboidPointIterator[3];
    protected int activeSegment = 0;
    protected BlockPos peeked = null;

    public ComplementsPointIterator(BlockBox volume, BlockBox intersect) {
        BlockPos vmax = volume.max();
        BlockPos imax = intersect.max();
        BlockPos vmin = volume.min();
        BlockPos imin = intersect.min();
        this.segments[0] = vmax.getX() != imax.getX() || vmin.getX() != imin.getX() ? (vmax.getX() > imax.getX() ? new CuboidPointIterator(new BlockPos(imax.getX(), vmin.getY(), vmin.getZ()), new BlockPos(vmax.getX(), vmax.getY(), vmax.getZ())) : new CuboidPointIterator(new BlockPos(vmin.getX(), vmin.getY(), vmin.getZ()), new BlockPos(imin.getX(), vmax.getY(), vmax.getZ()))) : CuboidPointIterator.NULL_ITERATOR;
        this.segments[1] = vmax.getY() != imax.getY() || vmin.getY() != imin.getY() ? (vmax.getY() > imax.getY() ? new CuboidPointIterator(new BlockPos(imin.getX(), imax.getY(), vmin.getZ()), new BlockPos(imax.getX(), vmax.getY(), vmax.getZ())) : new CuboidPointIterator(new BlockPos(imin.getX(), vmin.getY(), vmin.getZ()), new BlockPos(imax.getX(), imin.getY(), vmax.getZ()))) : CuboidPointIterator.NULL_ITERATOR;
        this.segments[2] = vmax.getZ() != imax.getZ() || vmin.getZ() != imin.getZ() ? (vmax.getZ() > imax.getZ() ? new CuboidPointIterator(new BlockPos(imin.getX(), imin.getY(), imax.getZ()), new BlockPos(imax.getX(), imax.getY(), vmax.getZ())) : new CuboidPointIterator(new BlockPos(imin.getX(), imin.getY(), vmin.getZ()), new BlockPos(imax.getX(), imax.getY(), imin.getZ()))) : CuboidPointIterator.NULL_ITERATOR;
        this.peeked = this.next0();
    }

    protected BlockPos next0() {
        while (this.activeSegment < this.segments.length) {
            BlockPos rv = this.segments[this.activeSegment].next();
            if (rv != null) {
                return rv;
            }
            ++this.activeSegment;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos peek() {
        return this.peeked;
    }

    @Override
    @Nullable
    public BlockPos next() {
        BlockPos result = this.peeked;
        this.peeked = this.next0();
        return result;
    }
}

