/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.scanner.IPointIterator;

public class CuboidPointIterator
implements IPointIterator {
    static final CuboidPointIterator NULL_ITERATOR = new CuboidPointIterator(){

        @Override
        public BlockPos next() {
            return null;
        }

        @Override
        public BlockPos peek() {
            return null;
        }
    };
    protected final Iterator<BlockPos> itr;
    protected BlockPos peeked;

    private CuboidPointIterator() {
        this.itr = null;
    }

    public CuboidPointIterator(BlockPos[] points) {
        this(points[0], points[1]);
    }

    public CuboidPointIterator(BlockPos p1, BlockPos p2) {
        this.itr = BlockPos.betweenClosed((BlockPos)p1, (BlockPos)p2).iterator();
        this.peeked = this.itr.next();
    }

    @Override
    @Nullable
    public BlockPos next() {
        BlockPos result = this.peeked;
        this.peeked = this.itr.hasNext() ? this.itr.next() : null;
        return result;
    }

    @Override
    @Nullable
    public BlockPos peek() {
        return this.peeked;
    }
}

