/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import java.util.Collection;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scanner.ComplementsPointIterator;
import org.orecruncher.dsurround.lib.scanner.Cuboid;
import org.orecruncher.dsurround.lib.scanner.CuboidPointIterator;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.lib.scanner.Scanner;

public abstract class CuboidScanner
extends Scanner {
    protected boolean scanFinished = false;
    protected BlockBox activeCuboid;
    protected CuboidPointIterator fullRange;
    protected BlockPos lastPos = BlockPos.ZERO;
    protected ResourceLocation lastReference = ResourceLocation.parse((String)"dsurround:aintnothin");

    protected CuboidScanner(ScanContext locus, String name, int range) {
        super(locus, name, range);
    }

    protected BlockPos[] getMinMaxPointsForVolume(BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.setWithOffset((Vec3i)pos, -this.xRange, -this.yRange, -this.zRange);
        mutable.setY(this.locus.clampHeight(mutable.getY()));
        BlockPos min = mutable.immutable();
        mutable.setWithOffset((Vec3i)pos, this.xRange, this.yRange, this.zRange);
        mutable.setY(this.locus.clampHeight(mutable.getY()));
        BlockPos max = mutable.immutable();
        return new BlockPos[]{min, max};
    }

    protected BlockBox getVolumeFor(BlockPos pos) {
        BlockPos[] points = this.getMinMaxPointsForVolume(pos);
        return Cuboid.of(points);
    }

    @Override
    protected void setRange(int range) {
        if (this.xRange != range || this.yRange != range || this.zRange != range) {
            super.setRange(range);
            this.resetFullScan();
        }
    }

    public void resetFullScan() {
        this.lastPos = this.locus.getScanCenter();
        this.lastReference = this.locus.getWorldReference();
        this.scanFinished = false;
        BlockPos[] points = this.getMinMaxPointsForVolume(this.lastPos);
        this.activeCuboid = Cuboid.of(points);
        this.fullRange = new CuboidPointIterator(points);
    }

    @Override
    public void tick() {
        BlockPos playerPos = this.locus.getScanCenter();
        if (this.locus.isOutOfHeightLimit(playerPos.getY())) {
            this.fullRange = null;
        } else if (this.fullRange == null || this.locus.getWorldReference() != this.lastReference) {
            this.locus.getLogger().debug("[%s] full range reset", this.name);
            this.resetFullScan();
            super.tick();
        } else if (this.lastPos.equals((Object)playerPos)) {
            if (!this.scanFinished) {
                super.tick();
            }
        } else {
            BlockBox newVolume;
            BlockBox oldVolume = this.activeCuboid != null ? this.activeCuboid : this.getVolumeFor(this.lastPos);
            BlockBox intersect = Cuboid.intersection(oldVolume, newVolume = this.getVolumeFor(playerPos));
            if (intersect == null) {
                this.locus.getLogger().debug("[%s] no intersection: %s, %s", this.name, oldVolume.toString(), newVolume.toString());
                this.resetFullScan();
                super.tick();
            } else if (this.scanFinished) {
                this.lastPos = playerPos;
                this.activeCuboid = newVolume;
                this.updateScan(newVolume, oldVolume, intersect);
            } else {
                super.tick();
            }
        }
    }

    public boolean doBlockUnscan() {
        return false;
    }

    public void blockUnscan(Level world, BlockState state, BlockPos pos, IRandomizer rand) {
    }

    protected void updateScan(BlockBox newVolume, BlockBox oldVolume, BlockBox intersect) {
        BlockState state;
        BlockPos point;
        Level provider = this.locus.getWorld();
        if (this.doBlockUnscan()) {
            ComplementsPointIterator newOutOfRange = new ComplementsPointIterator(oldVolume, intersect);
            point = newOutOfRange.next();
            while (point != null) {
                if (!this.locus.isOutOfHeightLimit(point.getY())) {
                    state = provider.getBlockState(point);
                    this.blockUnscan(provider, state, point, this.random);
                }
                point = newOutOfRange.next();
            }
        }
        ComplementsPointIterator newInRange = new ComplementsPointIterator(newVolume, intersect);
        point = newInRange.next();
        while (point != null) {
            if (!this.locus.isOutOfHeightLimit(point.getY())) {
                state = provider.getBlockState(point);
                this.blockScan(provider, state, point, this.random);
            }
            point = newInRange.next();
        }
        this.scanFinished = true;
    }

    @Override
    @Nullable
    protected BlockPos nextPos(BlockPos.MutableBlockPos workingPos, IRandomizer rand) {
        BlockPos point;
        if (this.scanFinished) {
            return null;
        }
        int checked = 0;
        while ((point = this.fullRange.peek()) != null) {
            this.fullRange.next();
            if (!this.locus.isOutOfHeightLimit(point.getY())) {
                return point;
            }
            if (++checked < this.blocksPerTick) continue;
            return null;
        }
        this.scanFinished = true;
        return null;
    }

    public void onBlockUpdates(Collection<BlockPos> positions) {
        if (!positions.isEmpty() && this.activeCuboid != null) {
            Level world = this.locus.getWorld();
            positions.stream().filter(p -> this.activeCuboid.contains(p)).forEach(p -> {
                BlockState state = world.getBlockState(p);
                if (!Constants.BLOCKS_TO_IGNORE.contains(state.getBlock())) {
                    try {
                        this.blockScan(world, state, (BlockPos)p, this.random);
                    }
                    catch (Throwable t) {
                        this.locus.getLogger().error(t, "onBlockUpdate() error %s for state %s", p.toString(), state.toString());
                    }
                }
            });
        }
    }
}

