/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.scanner.ScanContext;

public abstract class Scanner {
    private static final int MAX_BLOCKS_TICK = 6000;
    protected final String name;
    protected int xRange;
    protected int yRange;
    protected int zRange;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int blocksPerTick;
    protected int volume;
    protected final ScanContext locus;
    protected final IRandomizer random = Randomizer.current();
    protected final BlockPos.MutableBlockPos workingPos = new BlockPos.MutableBlockPos();

    public Scanner(ScanContext locus, String name, int range) {
        this(locus, name, range, range, range);
    }

    public Scanner(ScanContext locus, String name, int xRange, int yRange, int zRange) {
        this.name = name;
        this.locus = locus;
        this.setRange(xRange, yRange, zRange);
    }

    protected void setRange(int range) {
        this.setRange(range, range, range);
    }

    protected void setRange(int xRange, int yRange, int zRange) {
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.xSize = xRange * 2 + 1;
        this.ySize = yRange * 2 + 1;
        this.zSize = zRange * 2 + 1;
        this.volume = this.xSize * this.ySize * this.zSize;
        this.blocksPerTick = Math.min(this.volume / 20, 6000);
    }

    public int getVolume() {
        return this.volume;
    }

    public abstract void blockScan(Level var1, BlockState var2, BlockPos var3, IRandomizer var4);

    public void tick() {
        BlockPos pos;
        Level world = this.locus.getWorld();
        for (int count = 0; count < this.blocksPerTick && (pos = this.nextPos(this.workingPos, this.random)) != null; ++count) {
            BlockState state = world.getBlockState(pos);
            if (Constants.BLOCKS_TO_IGNORE.contains(state.getBlock())) continue;
            this.blockScan(world, state, pos, this.random);
        }
    }

    @Nullable
    protected abstract BlockPos nextPos(BlockPos.MutableBlockPos var1, IRandomizer var2);
}

