/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.seasons;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.orecruncher.dsurround.lib.GameUtils;

public interface ISeasonalInformation {
    public String getProviderName();

    public Optional<Component> getCurrentSeason();

    public Optional<Component> getCurrentSeasonTranslated();

    default public boolean isSpring() {
        return true;
    }

    default public boolean isSummer() {
        return false;
    }

    default public boolean isAutumn() {
        return false;
    }

    default public boolean isWinter() {
        return false;
    }

    public float getTemperature(BlockPos var1);

    default public boolean isColdTemperature(BlockPos blockPos) {
        return this.getTemperature(blockPos) < 0.2f;
    }

    default public boolean isSnowTemperature(BlockPos blockPos) {
        return this.getTemperature(blockPos) < 0.15f;
    }

    default public int getPrecipitationHeight(BlockPos pos) {
        return this.level().getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
    }

    default public Biome.Precipitation getPrecipitationAt(BlockPos blockPos) {
        return ((Biome)this.level().getBiome(blockPos).value()).getPrecipitationAt(blockPos);
    }

    default public Biome.Precipitation getActivePrecipitation(BlockPos pos) {
        if (!this.level().isRaining()) {
            return Biome.Precipitation.NONE;
        }
        if (this.getPrecipitationAt(pos) == Biome.Precipitation.NONE) {
            return Biome.Precipitation.NONE;
        }
        int p = this.getPrecipitationHeight(pos);
        if (p > pos.getY()) {
            return Biome.Precipitation.NONE;
        }
        return this.isSnowTemperature(pos) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    default public ClientLevel level() {
        return GameUtils.getWorld().orElseThrow();
    }
}

