/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.seasons.compat;

import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.lib.seasons.compat.AbstractSeasonProvider;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.season.SeasonHooks;

public class SereneSeasons
extends AbstractSeasonProvider {
    private Season.SubSeason subSeason;
    private Season.TropicalSeason tropicalSeason;
    private Component computed;
    private final IDimensionInformation dimensionInformation;

    public SereneSeasons(IDimensionInformation dimensionInformation) {
        super("Serene Seasons");
        this.dimensionInformation = dimensionInformation;
    }

    @Override
    public Optional<Component> getCurrentSeason() {
        ISeasonState helper = SeasonHelper.getSeasonState((Level)this.level());
        Season.SubSeason subSeason = helper.getSubSeason();
        return Optional.of(Component.literal((String)subSeason.toString()));
    }

    @Override
    public Optional<Component> getCurrentSeasonTranslated() {
        ISeasonState helper = SeasonHelper.getSeasonState((Level)this.level());
        if (this.subSeason != helper.getSubSeason() || this.tropicalSeason != helper.getTropicalSeason()) {
            String subSeasonKey = "desc.sereneseasons." + helper.getSeason().toString().toLowerCase(Locale.ROOT);
            String tropicalSeasonKey = "desc.sereneseasons." + helper.getTropicalSeason().toString().toLowerCase(Locale.ROOT);
            MutableComponent subSeason = Component.translatable((String)subSeasonKey);
            MutableComponent tropicalSeason = Component.translatable((String)tropicalSeasonKey);
            this.computed = Component.translatable((String)"%s (%s)", (Object[])new Object[]{subSeason, tropicalSeason});
            this.subSeason = helper.getSubSeason();
            this.tropicalSeason = helper.getTropicalSeason();
        }
        return Optional.of(this.computed);
    }

    @Override
    public boolean isSpring() {
        ISeasonState helper = SeasonHelper.getSeasonState((Level)this.level());
        return helper.getSeason() == Season.SPRING;
    }

    @Override
    public boolean isSummer() {
        ISeasonState helper = SeasonHelper.getSeasonState((Level)this.level());
        return helper.getSeason() == Season.SUMMER;
    }

    @Override
    public boolean isAutumn() {
        ISeasonState helper = SeasonHelper.getSeasonState((Level)this.level());
        return helper.getSeason() == Season.AUTUMN;
    }

    @Override
    public boolean isWinter() {
        ISeasonState helper = SeasonHelper.getSeasonState((Level)this.level());
        return helper.getSeason() == Season.WINTER;
    }

    @Override
    public Biome.Precipitation getPrecipitationAt(BlockPos blockPos) {
        ClientLevel level = this.level();
        Holder biome = level.getBiome(blockPos);
        return SeasonHooks.getPrecipitationAtSeasonal((Level)level, (Holder)biome, (BlockPos)blockPos);
    }

    @Override
    public float getTemperature(BlockPos blockPos) {
        ClientLevel level = this.level();
        Holder biome = level.getBiome(blockPos);
        return SeasonHooks.getBiomeTemperature((Level)level, (Holder)biome, (BlockPos)blockPos);
    }

    @Override
    public ClientLevel level() {
        return this.dimensionInformation.level();
    }
}

