/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.system;

import java.time.Instant;
import org.orecruncher.dsurround.lib.system.IStopwatch;
import org.orecruncher.dsurround.lib.system.ISystemClock;
import org.orecruncher.dsurround.lib.system.Stopwatch;

public final class SystemClock
implements ISystemClock {
    public static final long NANOS_PER_SECOND = 1000000000L;
    private static final long EPOCH_NANOS = System.currentTimeMillis() * 1000000L;
    private static final long NANO_START = System.nanoTime();
    private static final long OFFSET_NANOS = EPOCH_NANOS - NANO_START;

    @Override
    public long getUtcNanosNow() {
        return System.nanoTime() + OFFSET_NANOS;
    }

    @Override
    public Instant getUtcNow() {
        long now = this.getUtcNanosNow();
        return Instant.ofEpochSecond(now / 1000000000L, now % 1000000000L);
    }

    @Override
    public IStopwatch getStopwatch() {
        return new Stopwatch(this);
    }
}

