/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.version;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class SemanticVersion
implements Comparable<SemanticVersion> {
    public static final Codec<SemanticVersion> CODEC = Codec.STRING.comapFlatMap(SemanticVersion::manifest, SemanticVersion::toString).stable();
    public final int major;
    public final int minor;
    public final int patch;
    private final String[] preRelease;
    private final String[] buildMeta;
    private final int hashCode;

    private static DataResult<SemanticVersion> manifest(String versionData) {
        try {
            return DataResult.success((Object)SemanticVersion.parse(versionData));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }

    public SemanticVersion(int major, int minor, int patch) {
        this(major, minor, patch, new String[0], new String[0]);
    }

    public SemanticVersion(int major, int minor, int patch, String[] preRelease, String[] buildMeta) {
        int i;
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Version numbers must be positive!");
        }
        this.buildMeta = new String[buildMeta.length];
        this.preRelease = new String[preRelease.length];
        Pattern p = Pattern.compile("[0-9A-Za-z-]+");
        for (i = 0; i < preRelease.length; ++i) {
            if (preRelease[i] == null || !p.matcher(preRelease[i]).matches()) {
                throw new IllegalArgumentException("Pre Release tag: " + i);
            }
            this.preRelease[i] = preRelease[i];
        }
        for (i = 0; i < buildMeta.length; ++i) {
            if (buildMeta[i] == null || !p.matcher(buildMeta[i]).matches()) {
                throw new IllegalArgumentException("Build Meta tag: " + i);
            }
            this.buildMeta[i] = buildMeta[i];
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.hashCode = this.toString().hashCode();
    }

    public boolean hasBuildMeta(String tag) {
        for (String s : this.buildMeta) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreRelease(String tag) {
        for (String s : this.preRelease) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public String[] getPreRelease() {
        return (String[])this.preRelease.clone();
    }

    public String[] getBuildMeta() {
        return (String[])this.buildMeta.clone();
    }

    public boolean isUpdateFor(SemanticVersion v) {
        return this.compareTo(v) > 0;
    }

    public boolean isCompatibleUpdateFor(SemanticVersion v) {
        return this.isUpdateFor(v) && this.major == v.major && this.major != 0;
    }

    public boolean isStable() {
        return this.major > 0 && this.preRelease.length == 0;
    }

    public String toString() {
        int i;
        StringBuilder ret = new StringBuilder();
        ret.append(this.major);
        ret.append('.');
        ret.append(this.minor);
        ret.append('.');
        ret.append(this.patch);
        if (this.preRelease.length > 0) {
            ret.append('-');
            for (i = 0; i < this.preRelease.length; ++i) {
                ret.append(this.preRelease[i]);
                if (i >= this.preRelease.length - 1) continue;
                ret.append('.');
            }
        }
        if (this.buildMeta.length > 0) {
            ret.append('+');
            for (i = 0; i < this.buildMeta.length; ++i) {
                ret.append(this.buildMeta[i]);
                if (i >= this.buildMeta.length - 1) continue;
                ret.append('.');
            }
        }
        return ret.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        int i;
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion ov = (SemanticVersion)other;
        if (ov.major != this.major || ov.minor != this.minor || ov.patch != this.patch) {
            return false;
        }
        if (ov.preRelease.length != this.preRelease.length) {
            return false;
        }
        for (i = 0; i < this.preRelease.length; ++i) {
            if (this.preRelease[i].equals(ov.preRelease[i])) continue;
            return false;
        }
        if (ov.buildMeta.length != this.buildMeta.length) {
            return false;
        }
        for (i = 0; i < this.buildMeta.length; ++i) {
            if (this.buildMeta[i].equals(ov.buildMeta[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(SemanticVersion v) {
        int result = this.major - v.major;
        if (result == 0 && (result = this.minor - v.minor) == 0 && (result = this.patch - v.patch) == 0) {
            if (this.preRelease.length == 0 && v.preRelease.length > 0) {
                result = 1;
            }
            if (v.preRelease.length == 0 && this.preRelease.length > 0) {
                result = -1;
            }
            if (this.preRelease.length > 0 && v.preRelease.length > 0) {
                int len = Math.min(this.preRelease.length, v.preRelease.length);
                int count = 0;
                for (count = 0; count < len && (result = this.comparePreReleaseTag(count, v)) == 0; ++count) {
                }
                if (result == 0 && count == len) {
                    result = this.preRelease.length - v.preRelease.length;
                }
            }
        }
        return result;
    }

    private int comparePreReleaseTag(int pos, SemanticVersion ov) {
        Integer here = null;
        Integer there = null;
        try {
            here = Integer.parseInt(this.preRelease[pos], 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            there = Integer.parseInt(ov.preRelease[pos], 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (here != null && there == null) {
            return -1;
        }
        if (here == null && there != null) {
            return 1;
        }
        if (here == null) {
            return this.preRelease[pos].compareTo(ov.preRelease[pos]);
        }
        return here.compareTo(there);
    }

    public static SemanticVersion parse(String versionString) throws ParseException {
        Parser parser = new Parser();
        if (parser.parse(versionString)) {
            return new SemanticVersion(parser.vParts[0], parser.vParts[1], parser.vParts[2], parser.preParts.toArray(new String[0]), parser.metaParts.toArray(new String[0]));
        }
        throw new ParseException(versionString, parser.errPos);
    }

    private static class Parser {
        private int errPos;
        private char[] input;
        public final int[] vParts = new int[3];
        public ArrayList<String> preParts = new ArrayList();
        public ArrayList<String> metaParts = new ArrayList();

        public boolean parse(String versionString) {
            Arrays.fill(this.vParts, 0);
            this.preParts.clear();
            this.metaParts.clear();
            this.input = versionString.toCharArray();
            this.errPos = 0;
            return this.stateMajor();
        }

        private boolean stateMajor() {
            int pos;
            for (pos = 0; pos < this.input.length && this.input[pos] >= '0' && this.input[pos] <= '9'; ++pos) {
            }
            if (pos == 0) {
                return false;
            }
            if (this.input[0] == '0' && pos > 1) {
                return false;
            }
            this.vParts[0] = Integer.parseInt(new String(this.input, 0, pos), 10);
            if (this.input[pos] == '.') {
                return this.stateMinor(pos + 1);
            }
            return false;
        }

        private boolean stateMinor(int index) {
            int pos;
            for (pos = index; pos < this.input.length && this.input[pos] >= '0' && this.input[pos] <= '9'; ++pos) {
            }
            if (pos == index) {
                this.errPos = index;
                return false;
            }
            if (this.input[index] == '0' && pos - index > 1) {
                this.errPos = index;
                return false;
            }
            this.vParts[1] = Integer.parseInt(new String(this.input, index, pos - index), 10);
            if (this.input[pos] == '.') {
                return this.statePatch(pos + 1);
            }
            this.errPos = pos;
            return false;
        }

        private boolean statePatch(int index) {
            int pos;
            for (pos = index; pos < this.input.length && this.input[pos] >= '0' && this.input[pos] <= '9'; ++pos) {
            }
            if (pos == index) {
                this.errPos = index;
                return false;
            }
            if (this.input[index] == '0' && pos - index > 1) {
                this.errPos = index;
                return false;
            }
            this.vParts[2] = Integer.parseInt(new String(this.input, index, pos - index), 10);
            if (pos == this.input.length) {
                return true;
            }
            if (this.input[pos] == '+') {
                return this.stateMeta(pos + 1);
            }
            if (this.input[pos] == '-') {
                return this.stateRelease(pos + 1);
            }
            this.errPos = pos;
            return false;
        }

        private boolean stateRelease(int index) {
            int pos;
            for (pos = index; pos < this.input.length && (this.input[pos] >= '0' && this.input[pos] <= '9' || this.input[pos] >= 'a' && this.input[pos] <= 'z' || this.input[pos] >= 'A' && this.input[pos] <= 'Z' || this.input[pos] == '-'); ++pos) {
            }
            if (pos == index) {
                this.errPos = index;
                return false;
            }
            this.preParts.add(new String(this.input, index, pos - index));
            if (pos == this.input.length) {
                return true;
            }
            if (this.input[pos] == '.') {
                return this.stateRelease(pos + 1);
            }
            if (this.input[pos] == '+') {
                return this.stateMeta(pos + 1);
            }
            this.errPos = pos;
            return false;
        }

        private boolean stateMeta(int index) {
            int pos;
            for (pos = index; pos < this.input.length && (this.input[pos] >= '0' && this.input[pos] <= '9' || this.input[pos] >= 'a' && this.input[pos] <= 'z' || this.input[pos] >= 'A' && this.input[pos] <= 'Z' || this.input[pos] == '-'); ++pos) {
            }
            if (pos == index) {
                this.errPos = index;
                return false;
            }
            this.metaParts.add(new String(this.input, index, pos - index));
            if (pos == this.input.length) {
                return true;
            }
            if (this.input[pos] == '.') {
                return this.stateMeta(pos + 1);
            }
            this.errPos = pos;
            return false;
        }
    }
}

