/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.version;

import com.mojang.datafixers.util.Pair;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.platform.ModInformation;
import org.orecruncher.dsurround.lib.version.IVersionChecker;
import org.orecruncher.dsurround.lib.version.SemanticVersion;
import org.orecruncher.dsurround.lib.version.VersionInformation;
import org.orecruncher.dsurround.lib.version.VersionResult;

public class VersionChecker
implements IVersionChecker {
    private final IModLog logger;
    private final ModInformation modInfo;

    public VersionChecker(ModInformation modInformation, IModLog logger) {
        this.logger = logger;
        this.modInfo = modInformation;
    }

    @Override
    public Optional<VersionResult> getUpdateText() {
        return this.getVersionInformation().flatMap(this::getUpdateText);
    }

    private Optional<VersionInformation> getVersionInformation() {
        return this.getVersionData().flatMap(c -> CodecExtensions.deserialize(c, VersionInformation.CODEC));
    }

    private Optional<String> getVersionData() {
        return this.modInfo.getUpdateUrl().map(url -> {
            String string;
            block8: {
                InputStream in = url.openStream();
                try {
                    byte[] bytes = in.readAllBytes();
                    string = new String(bytes, StandardCharsets.UTF_8);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        this.logger.error(t, "Unable to fetch version information from %s", this.modInfo.getUpdateUrl());
                        return null;
                    }
                }
                in.close();
            }
            return string;
        });
    }

    private Optional<VersionResult> getUpdateText(VersionInformation info) {
        SemanticVersion semVer;
        Optional<Pair<SemanticVersion, String>> newest;
        Optional<SemanticVersion> mcVersion = ModInformation.getMinecraftVersion();
        if (mcVersion.isPresent() && (newest = info.getNewestVersion(semVer = mcVersion.get(), this.modInfo.version())).isPresent()) {
            SemanticVersion version = (SemanticVersion)newest.get().getFirst();
            String releaseNotes = (String)newest.get().getSecond();
            return Optional.of(new VersionResult(version.toString(), this.modInfo.modId(), ChatFormatting.stripFormatting((String)this.modInfo.displayName()), this.modInfo.curseForgeLink(), this.modInfo.modrinthLink(), releaseNotes));
        }
        return Optional.empty();
    }
}

