/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.version;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import org.orecruncher.dsurround.lib.version.SemanticVersion;

public record VersionInformation(Map<SemanticVersion, Map<SemanticVersion, String>> releases, Map<SemanticVersion, SemanticVersion> recommended) {
    private static final Codec<Map<SemanticVersion, String>> CODEC_RELEASES = Codec.unboundedMap(SemanticVersion.CODEC, (Codec)Codec.STRING).stable();
    private static final Codec<Map<SemanticVersion, Map<SemanticVersion, String>>> MAJOR_VERSION_RELEASES = Codec.unboundedMap(SemanticVersion.CODEC, CODEC_RELEASES).stable();
    private static final Codec<Map<SemanticVersion, SemanticVersion>> RECOMMENDATION = Codec.unboundedMap(SemanticVersion.CODEC, SemanticVersion.CODEC).stable();
    public static final Codec<VersionInformation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MAJOR_VERSION_RELEASES.fieldOf("releases").forGetter(VersionInformation::releases), (App)RECOMMENDATION.fieldOf("recommend").forGetter(VersionInformation::recommended)).apply((Applicative)instance, VersionInformation::new));

    public Optional<Pair<SemanticVersion, String>> getNewestVersion(SemanticVersion minecraftVersion, SemanticVersion modVersion) {
        SemanticVersion recommendation = this.recommended.get(minecraftVersion);
        if (recommendation == null) {
            return Optional.empty();
        }
        if (modVersion.compareTo(recommendation) < 0) {
            String releaseNotes = "";
            Map<SemanticVersion, String> releases = this.releases.get(minecraftVersion);
            if (releases != null && (releaseNotes = releases.get(recommendation)) == null) {
                releaseNotes = "";
            }
            return Optional.of(Pair.of((Object)recommendation, (Object)releaseNotes));
        }
        return Optional.empty();
    }
}

