/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.audio;

import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.gui.sound.SoundToast;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.mixinutils.IMusicManager;
import org.orecruncher.dsurround.mixinutils.MixinHelpers;
import org.orecruncher.dsurround.sound.SoundMetadata;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public class MixinMusicManager
implements IMusicManager {
    @Shadow
    @Nullable
    private SoundInstance currentMusic;
    @Shadow
    private int nextSongDelay;
    @Unique
    private boolean dsurround_pauseTicking;

    @Override
    public String dsurround_getDiagnosticText() {
        String playingSound = "Nothing playing";
        if (this.currentMusic != null) {
            playingSound = this.currentMusic.getLocation().toString();
        }
        Object result = "Music Manager: %d (%s)".formatted(this.nextSongDelay, playingSound);
        if (this.dsurround_pauseTicking) {
            result = (String)result + " (PAUSED)";
        }
        return result;
    }

    @Override
    public void dsurround_doCommand(String command) {
        if ("reset".equals(command)) {
            MusicManager self = (MusicManager)this;
            self.stopPlaying();
            this.nextSongDelay = 100;
            this.dsurround_pauseTicking = false;
        } else if ("pause".equals(command)) {
            this.dsurround_setPaused(true);
        } else if ("unpause".equals(command)) {
            this.dsurround_setPaused(false);
        }
    }

    @Override
    public void dsurround_setPaused(boolean flag) {
        MusicManager self = (MusicManager)this;
        if (flag) {
            MixinHelpers.LOGGER.info("Stopping MusicManager", new Object[0]);
            this.dsurround_pauseTicking = true;
            self.stopPlaying();
        } else {
            MixinHelpers.LOGGER.info("Starting MusicManager", new Object[0]);
            this.nextSongDelay = 100;
            this.dsurround_pauseTicking = false;
        }
    }

    @Override
    public Component dsurround_whatsPlaying() {
        if (this.currentMusic == null) {
            return Component.translatable((String)"dsurround.text.musicmanager.nothing");
        }
        SoundMetadata metaData = MixinHelpers.SOUND_LIBRARY.getSoundMetadata(this.currentMusic.getLocation());
        if (metaData == null || Component.empty().equals((Object)metaData.getTitle())) {
            return Component.literal((String)this.currentMusic.getLocation().toString());
        }
        MutableComponent title = metaData.getTitle().copy().withColor(ColorPalette.PUMPKIN_ORANGE.getValue());
        MutableComponent author = metaData.getCredits().get(0).author().copy().withColor(ColorPalette.WHEAT.getValue());
        return Component.translatable((String)"dsurround.text.musicmanager.playing", (Object[])new Object[]{title, author, Component.translationArg((ResourceLocation)this.currentMusic.getLocation())});
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void dsurround_pauseTickCheck(CallbackInfo ci) {
        if (this.dsurround_pauseTicking) {
            ci.cancel();
        }
    }

    @Inject(method={"startPlaying(Lnet/minecraft/sounds/Music;)V"}, at={@At(value="RETURN")})
    public void dsurround_startPlaying(Music music, CallbackInfo ci) {
        if (MixinHelpers.soundOptions.displayToastMessagesForMusic) {
            SoundToast.create(music);
        }
    }
}

