/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.core;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.Music;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.mixinutils.IBiomeExtended;
import org.orecruncher.dsurround.mixinutils.MixinHelpers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public abstract class MixinBiome
implements IBiomeExtended {
    @Unique
    private BiomeInfo dsurround_info;
    @Final
    @Shadow
    private Biome.ClimateSettings climateSettings;
    @Final
    @Shadow
    private BiomeSpecialEffects specialEffects;

    @Override
    public BiomeSpecialEffects dsurround_getSpecialEffects() {
        return this.specialEffects;
    }

    @Override
    public BiomeInfo dsurround_getInfo() {
        return this.dsurround_info;
    }

    @Override
    public void dsurround_setInfo(BiomeInfo info) {
        this.dsurround_info = info;
    }

    @Override
    public Biome.ClimateSettings dsurround_getWeather() {
        return this.climateSettings;
    }

    @Override
    @Invoker(value="getTemperature")
    public abstract float dsurround_getTemperature(BlockPos var1);

    @Inject(method={"getFogColor()I"}, at={@At(value="HEAD")}, cancellable=true)
    public void dsurround_getFogColor(CallbackInfoReturnable<Integer> cir) {
        TextColor color;
        if (MixinHelpers.fogOptions.enableFogEffects && MixinHelpers.fogOptions.enableBiomeFog && this.dsurround_info != null && (color = this.dsurround_info.getFogColor()) != null) {
            cir.setReturnValue((Object)color.getValue());
        }
    }

    @Inject(method={"getBackgroundMusic()Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private void dsurround_getBackgroundMusic(CallbackInfoReturnable<Optional<Music>> cir) {
        if (this.dsurround_info == null) {
            cir.setReturnValue(Optional.empty());
        } else {
            Optional<Music> result = this.dsurround_info.getBackgroundMusic(Randomizer.current());
            if (result.isPresent()) {
                cir.setReturnValue(result);
            }
        }
    }
}

