/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.core;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.LevelChunk;
import org.orecruncher.dsurround.mixins.core.MixinClientChunkManager;
import org.orecruncher.dsurround.mixins.core.MixinClientChunkMap;
import org.orecruncher.dsurround.mixinutils.IClientWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public class MixinClientWorld
implements IClientWorld {
    @Final
    @Shadow
    private ClientChunkCache chunkSource;
    @Unique
    private long dsurround_worldseed;

    @Inject(method={"<init>(Lnet/minecraft/client/multiplayer/ClientPacketListener;Lnet/minecraft/client/multiplayer/ClientLevel$ClientLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/Holder;IILjava/util/function/Supplier;Lnet/minecraft/client/renderer/LevelRenderer;ZJ)V"}, at={@At(value="RETURN")})
    public void dsurround_ctor(ClientPacketListener clientPacketListener, ClientLevel.ClientLevelData clientLevelData, ResourceKey resourceKey, Holder holder, int i, int j, Supplier supplier, LevelRenderer levelRenderer, boolean bl, long l, CallbackInfo ci) {
        this.dsurround_worldseed = l;
    }

    @Override
    public long dsurround_getWorldSeed() {
        return this.dsurround_worldseed;
    }

    @Override
    @Unique
    public Stream<LevelChunk> dsurround_getLoadedChunks() {
        MixinClientChunkManager x = (MixinClientChunkManager)this.chunkSource;
        ClientChunkCache.Storage chunkMap = x.dsurround_getClientChunkMap();
        AtomicReferenceArray<LevelChunk> chunks = ((MixinClientChunkMap)chunkMap).dsurround_getChunks();
        ArrayList<LevelChunk> resultChunks = new ArrayList<LevelChunk>();
        for (int i = 0; i < chunks.length(); ++i) {
            LevelChunk chunk = chunks.get(i);
            if (chunk == null) continue;
            resultChunks.add(chunk);
        }
        return resultChunks.stream();
    }
}

