/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.core;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.mixinutils.MixinHelpers;
import org.orecruncher.dsurround.tags.EntityEffectTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Unique
    private static final double DSURROUND_MAX_ACCENT_RANGE = 256.0;
    @Shadow
    private Level level;

    @Inject(method={"walkingStepSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="TAIL")})
    public void dsurround_playStepSound(BlockPos pos, BlockState state, CallbackInfo ci) {
        if (MixinHelpers.footstepAccentsConfig.enableAccents && this.level.isClientSide) {
            Entity self = (Entity)this;
            if (GameUtils.getPlayer().orElseThrow().distanceToSqr(self) > 256.0) {
                return;
            }
            if (MixinHelpers.TAG_LIBRARY.is(EntityEffectTags.BRUSH_STEP, self.getType())) {
                ((ClientEventHooks.IEntityStep)ClientEventHooks.ENTITY_STEP_EVENT.raise()).onStep(self, pos, state);
            }
        }
    }
}

