/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.core;

import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.gui.screens.options.SoundOptionsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlScreen;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.mixinutils.IMusicManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundOptionsScreen.class})
public abstract class MixinSoundOptionsScreen
extends OptionsSubScreen {
    public MixinSoundOptionsScreen(Screen screen, Options options, Component component) {
        super(screen, options, component);
    }

    @Inject(method={"addOptions()V"}, at={@At(value="RETURN")})
    public void dsurround_addSoundConfigButton(CallbackInfo ci) {
        Tooltip toolTip = Tooltip.create((Component)Component.translatable((String)"dsurround.text.config.soundconfiguration.tooltip"));
        Style style = Style.EMPTY.withColor(ColorPalette.GOLD);
        MutableComponent buttonText = Component.translatable((String)"dsurround.text.config.soundconfiguration").withStyle(style);
        int textWidth = GameUtils.getTextRenderer().width((FormattedText)buttonText) + 10;
        Button buttonToAdd = Button.builder((Component)buttonText, this::dsurround_onPress).tooltip(toolTip).bounds(5, this.height - 27, textWidth, 20).build();
        this.layout.addToFooter((LayoutElement)buttonToAdd, settings -> settings.alignHorizontally(0.01f));
    }

    @Unique
    private void dsurround_onPress(Button button) {
        boolean enablePlayButtons = GameUtils.getMC().level == null || GameUtils.isSinglePlayer();
        IMusicManager musicManager = (IMusicManager)GameUtils.getMC().getMusicManager();
        if (enablePlayButtons) {
            musicManager.dsurround_setPaused(true);
        }
        IndividualSoundControlScreen screen = new IndividualSoundControlScreen((Screen)this, enablePlayButtons, ignore -> {
            GameUtils.getSoundManager().stop();
            if (enablePlayButtons) {
                musicManager.dsurround_setPaused(false);
            }
        });
        this.minecraft.setScreen((Screen)screen);
    }
}

