/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import com.google.common.base.MoreObjects;
import net.minecraft.world.entity.player.Player;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.di.Cacheable;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;

@Cacheable
abstract class AbstractClientHandler {
    protected static final IRandomizer RANDOM = Randomizer.current();
    protected final Configuration config;
    protected final IModLog logger;
    private final String handlerName;
    private final TimerEMA timer;

    AbstractClientHandler(String name, Configuration config, IModLog logger) {
        this.handlerName = name;
        this.config = config;
        this.logger = logger;
        this.timer = new TimerEMA(this.handlerName);
    }

    public TimerEMA getTimer() {
        return this.timer;
    }

    public final String getHandlerName() {
        return this.handlerName;
    }

    public boolean doTick(long tick) {
        return true;
    }

    public void process(Player player) {
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
    }

    final void updateTimer(long nanos) {
        this.timer.update(nanos);
    }

    final void connect0() {
        this.onConnect();
    }

    final void disconnect0() {
        this.onDisconnect();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getHandlerName()).toString();
    }
}

