/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import net.minecraft.client.resources.sounds.SoundInstance;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.ISoundFactory;

public final class BiomeSoundEmitter {
    private final IModLog logger;
    private final IAudioPlayer audioPlayer;
    private final ISoundFactory soundEvent;
    private final BackgroundSoundLoop acousticSource;
    private boolean done = false;

    public BiomeSoundEmitter(IModLog logger, IAudioPlayer audioPlayer, ISoundFactory event) {
        this.logger = logger;
        this.audioPlayer = audioPlayer;
        this.soundEvent = event;
        this.acousticSource = event.createBackgroundSoundLoop();
    }

    public void tick() {
        boolean isPlaying = this.audioPlayer.isPlaying((SoundInstance)this.acousticSource);
        if (isPlaying) {
            return;
        }
        if (this.isFading()) {
            this.done = true;
            return;
        }
        this.audioPlayer.play((SoundInstance)this.acousticSource);
    }

    public void setVolumeScale(float scale) {
        this.acousticSource.setScaleTarget(scale);
    }

    public void fadeOut() {
        this.logger.debug("FADE OUT: %s", this.acousticSource.toString());
        this.acousticSource.fadeOut();
    }

    public boolean isFading() {
        return this.acousticSource.isFading();
    }

    public void fadeIn() {
        this.logger.debug("FADE IN: %s", this.acousticSource.toString());
        this.acousticSource.fadeIn();
    }

    public boolean isDone() {
        return this.done || this.acousticSource.isStopped();
    }

    public void stop() {
        this.audioPlayer.stop((SoundInstance)this.acousticSource);
        this.done = true;
    }

    public ISoundFactory getSoundEvent() {
        return this.soundEvent;
    }

    public String toString() {
        return this.acousticSource.toString();
    }
}

