/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.Collection;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.SoundEventType;
import org.orecruncher.dsurround.config.SyntheticBiome;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.processing.AbstractClientHandler;
import org.orecruncher.dsurround.processing.BiomeSoundEmitter;
import org.orecruncher.dsurround.processing.Scanners;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.ISoundFactory;

public final class BiomeSoundHandler
extends AbstractClientHandler {
    public static final int SCAN_INTERVAL = 4;
    public static final int MOOD_SOUND_MIN_RANGE = 8;
    public static final int MOOD_SOUND_MAX_RANGE = 16;
    private final IBiomeLibrary biomeLibrary;
    private final IAudioPlayer audioPlayer;
    private final ITickCount tickCount;
    private final Scanners scanner;
    private final Object2FloatOpenHashMap<ISoundFactory> workMap = new Object2FloatOpenHashMap(8, 0.75f);
    private final ObjectArray<BiomeSoundEmitter> emitters = new ObjectArray(8);

    public BiomeSoundHandler(IBiomeLibrary biomeLibrary, IAudioPlayer audioPlayer, ITickCount tickCount, Scanners scanner, Configuration config, IModLog logger) {
        super("Biome Sounds", config, logger);
        this.audioPlayer = audioPlayer;
        this.biomeLibrary = biomeLibrary;
        this.tickCount = tickCount;
        this.scanner = scanner;
        this.workMap.defaultReturnValue(0.0f);
    }

    private boolean doBiomeSounds() {
        return true;
    }

    private void generateBiomeSounds() {
        float area = this.scanner.getBiomeArea();
        for (Reference2IntMap.Entry kvp : this.scanner.getBiomes().reference2IntEntrySet()) {
            Collection<ISoundFactory> acoustics = ((BiomeInfo)kvp.getKey()).findBiomeSoundMatches();
            float volume = 0.05f + 0.95f * ((float)kvp.getIntValue() / area);
            for (ISoundFactory acoustic : acoustics) {
                this.workMap.addTo((Object)acoustic, volume);
            }
        }
    }

    @Override
    public void process(Player player) {
        this.emitters.forEach(BiomeSoundEmitter::tick);
        if (this.tickCount.getTickCount() % 4L == 0L) {
            this.handleBiomeSounds(player);
        }
    }

    @Override
    public void onConnect() {
        this.clearSounds();
    }

    @Override
    public void onDisconnect() {
        this.clearSounds();
    }

    private void handleBiomeSounds(Player player) {
        this.workMap.clear();
        if (player.isAlive()) {
            boolean biomeSounds = this.doBiomeSounds();
            if (biomeSounds) {
                this.generateBiomeSounds();
            }
            ObjectArray<ISoundFactory> playerSounds = new ObjectArray<ISoundFactory>();
            BiomeInfo internalPlayerBiomeInfo = this.biomeLibrary.getBiomeInfo(SyntheticBiome.PLAYER);
            BiomeInfo internalVillageBiomeInfo = this.biomeLibrary.getBiomeInfo(SyntheticBiome.VILLAGE);
            playerSounds.addAll(internalPlayerBiomeInfo.findBiomeSoundMatches());
            playerSounds.addAll(internalVillageBiomeInfo.findBiomeSoundMatches());
            playerSounds.forEach(fx -> this.workMap.put(fx, 1.0f));
            if (biomeSounds) {
                BiomeInfo playerBiome = this.scanner.playerLogicBiomeInfo();
                this.handleAddOnSounds(player, playerBiome);
                this.handleAddOnSounds(player, internalPlayerBiomeInfo);
                this.handleAddOnSounds(player, internalVillageBiomeInfo);
            }
        }
        this.queueAmbientSounds();
    }

    private void handleAddOnSounds(Player player, BiomeInfo info) {
        info.getExtraSound(SoundEventType.MOOD, RANDOM).ifPresent(s -> {
            SimpleSoundInstance instance = s.createAsMood((Entity)player, 8, 16);
            this.audioPlayer.play((SoundInstance)instance);
        });
        info.getExtraSound(SoundEventType.ADDITION, RANDOM).ifPresent(s -> {
            SimpleSoundInstance instance = s.createAsAdditional();
            this.audioPlayer.play((SoundInstance)instance);
        });
    }

    private void queueAmbientSounds() {
        this.emitters.removeIf(entry -> {
            if (entry.isDone()) {
                return true;
            }
            float volume = this.workMap.getFloat((Object)entry.getSoundEvent());
            if (volume > 0.0f) {
                entry.setVolumeScale(volume);
                if (entry.isFading()) {
                    entry.fadeIn();
                }
                this.workMap.removeFloat((Object)entry.getSoundEvent());
            } else if (!entry.isFading()) {
                entry.fadeOut();
            }
            return false;
        });
        this.workMap.forEach((fx, volume) -> {
            BiomeSoundEmitter e = new BiomeSoundEmitter(this.logger, this.audioPlayer, (ISoundFactory)fx);
            e.setVolumeScale(volume.floatValue());
            this.emitters.add(e);
        });
    }

    public void clearSounds() {
        this.emitters.forEach(BiomeSoundEmitter::stop);
        this.emitters.clear();
        this.workMap.clear();
    }

    @Override
    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
        Collection<Component> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.Emitters);
        this.emitters.forEach(backgroundAcousticEmitter -> panelText.add((Component)Component.literal((String)backgroundAcousticEmitter.toString())));
    }
}

