/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IEntityEffectLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.processing.AbstractClientHandler;

public class EntityEffectHandler
extends AbstractClientHandler {
    private final IEntityEffectLibrary entityEffectLibrary;
    private int entityCount;
    private int entityEffectsTicked;

    public EntityEffectHandler(Configuration config, IEntityEffectLibrary entityEffectLibrary, IModLog logger) {
        super("EntityEffect Handler", config, logger);
        this.entityEffectLibrary = entityEffectLibrary;
    }

    private int effectRange() {
        return this.config.entityEffects.entityEffectRange;
    }

    private int scanRange() {
        int range = this.effectRange();
        return range + (range >> 1);
    }

    @Override
    public void process(Player player) {
        Level world = player.level();
        this.entityCount = 0;
        this.entityEffectsTicked = 0;
        AABB worldBox = AABB.unitCubeFromLowerCorner((Vec3)player.getEyePosition()).inflate((double)this.scanRange());
        List loadedEntities = world.getEntitiesOfClass(LivingEntity.class, worldBox);
        for (LivingEntity entity : loadedEntities) {
            ++this.entityCount;
            boolean hasInfo = this.entityEffectLibrary.doesEntityEffectInfoExist(entity);
            boolean inRange = entity.closerThan((Entity)player, (double)this.effectRange());
            EntityEffectInfo info = null;
            if (!hasInfo && entity.isAlive()) {
                if (inRange) {
                    info = this.entityEffectLibrary.getEntityEffectInfo(entity);
                }
            } else if (hasInfo) {
                info = this.entityEffectLibrary.getEntityEffectInfo(entity);
            }
            if (info == null) continue;
            if (inRange && info.isAlive() && !entity.isSpectator()) {
                if (info.isDefault()) continue;
                ++this.entityEffectsTicked;
                info.tick();
                continue;
            }
            info.deactivate();
            this.entityEffectLibrary.clearEntityEffectInfo(entity);
        }
    }

    @Override
    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
        event.add(CollectDiagnosticsEvent.Section.Systems, "Entity effects (range %d/%d): entities %d, ticked %d".formatted(this.effectRange(), this.scanRange(), this.entityCount, this.entityEffectsTicked));
    }
}

