/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.player.Player;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.processing.AbstractClientHandler;
import org.orecruncher.dsurround.processing.fog.HolisticFogRangeCalculator;

public class FogHandler
extends AbstractClientHandler {
    private final HolisticFogRangeCalculator fogCalculator;
    private FogRenderer.FogData lastData;

    public FogHandler(Configuration config, IModLog logger) {
        super("Fog Handler", config, logger);
        this.fogCalculator = new HolisticFogRangeCalculator(logger, config.fogOptions);
        this.lastData = new FogRenderer.FogData(FogRenderer.FogMode.FOG_TERRAIN);
        this.lastData.end = 192.0f;
        this.lastData.start = 192.0f;
        ClientEventHooks.FOG_RENDER_EVENT.register(this::renderFog);
    }

    @Override
    public void process(Player player) {
        if (this.fogCalculator.enabled()) {
            this.fogCalculator.tick();
        }
    }

    @Override
    public void onDisconnect() {
        this.fogCalculator.disconnect();
    }

    private void renderFog(FogRenderer.FogData data, float renderDistance, float partialTick) {
        if (this.fogCalculator.enabled()) {
            this.lastData = this.fogCalculator.render(data, renderDistance, partialTick);
            RenderSystem.setShaderFogStart((float)this.lastData.start);
            RenderSystem.setShaderFogEnd((float)this.lastData.end);
            RenderSystem.setShaderFogShape((FogShape)this.lastData.shape);
        } else {
            this.lastData = data;
        }
    }

    @Override
    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
        Object text = "Fog: %f/%f, %s, %s ".formatted(Float.valueOf(this.lastData.start), Float.valueOf(this.lastData.end), this.lastData.shape, this.lastData.mode);
        Optional<String> disabledText = this.fogCalculator.getDisabledText();
        if (disabledText.isPresent()) {
            text = (String)text + disabledText.get();
        }
        event.add(CollectDiagnosticsEvent.Section.Systems, (String)text);
    }
}

