/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlScreen;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.Cacheable;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.math.LoggingTimerEMA;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.lib.threading.IClientTasking;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.processing.AbstractClientHandler;
import org.orecruncher.dsurround.processing.AreaBlockEffects;
import org.orecruncher.dsurround.processing.BiomeSoundHandler;
import org.orecruncher.dsurround.processing.EntityEffectHandler;
import org.orecruncher.dsurround.processing.FogHandler;
import org.orecruncher.dsurround.processing.Scanners;
import org.orecruncher.dsurround.processing.StepAccentGenerator;
import org.orecruncher.dsurround.processing.accents.FootstepAccents;
import org.orecruncher.dsurround.processing.scanner.BiomeScanner;
import org.orecruncher.dsurround.processing.scanner.CeilingScanner;
import org.orecruncher.dsurround.processing.scanner.VillageScanner;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

@Cacheable
public class Handlers {
    private final Configuration config;
    private final IModLog logger;
    private final IClientTasking tasking;
    private final ITickCount tickCount;
    private final ISoundLibrary soundLibrary;
    private final IAudioPlayer audioPlayer;
    private final ObjectArray<AbstractClientHandler> effectHandlers = new ObjectArray();
    private final LoggingTimerEMA handlerTimer = new LoggingTimerEMA("Handlers");
    private boolean isConnected = false;
    private boolean startupSoundPlayed = false;

    public Handlers(Configuration config, IModLog logger, IClientTasking tasking, ITickCount tickCount, ISoundLibrary soundLibrary, IAudioPlayer audioPlayer) {
        this.config = config;
        this.logger = logger;
        this.tasking = tasking;
        this.tickCount = tickCount;
        this.soundLibrary = soundLibrary;
        this.audioPlayer = audioPlayer;
        this.init();
    }

    protected static Player getPlayer() {
        return GameUtils.getPlayer().orElseThrow();
    }

    private void register(Class<? extends AbstractClientHandler> clazz) {
        AbstractClientHandler handler = ContainerManager.resolve(clazz);
        this.effectHandlers.add(handler);
        this.logger.debug("Registered handler [%s]", handler.getHandlerName());
    }

    private void init() {
        this.startupSoundPlayed = !this.config.otherOptions.playRandomSoundOnStartup;
        this.register(Scanners.class);
        this.register(EntityEffectHandler.class);
        this.register(BiomeSoundHandler.class);
        this.register(AreaBlockEffects.class);
        this.register(StepAccentGenerator.class);
        this.register(FogHandler.class);
        ClientState.TICK_END.register(this::tick);
        ClientState.ON_CONNECT.register(this::onConnect);
        ClientState.ON_DISCONNECT.register(this::onDisconnect);
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::gatherDiagnostics, HandlerPriority.HIGH);
    }

    private void onConnect(Minecraft client) {
        try {
            this.tasking.execute(() -> {
                this.logger.info("Handlers connecting...", new Object[0]);
                if (this.isConnected) {
                    this.logger.warn("Attempt to connect when already connected; disconnecting first", new Object[0]);
                    this.onDisconnect(client);
                }
                this.effectHandlers.forEach(AbstractClientHandler::connect0);
                this.isConnected = true;
            });
        }
        catch (Exception ex) {
            this.logger.error(ex, "Unable to perform client connect", new Object[0]);
        }
    }

    private void onDisconnect(Minecraft client) {
        try {
            this.tasking.execute(() -> {
                this.logger.info("Client disconnecting...", new Object[0]);
                this.isConnected = false;
                this.effectHandlers.forEach(AbstractClientHandler::disconnect0);
            });
        }
        catch (Exception ex) {
            this.logger.error(ex, "Unable to perform client disconnect", new Object[0]);
        }
    }

    protected boolean doTick() {
        return GameUtils.isInGame() && !GameUtils.isPaused() && GameUtils.getCurrentScreen().map(s -> s instanceof IndividualSoundControlScreen).orElse(false) == false && this.isPlayerChunkLoaded();
    }

    protected boolean isPlayerChunkLoaded() {
        Player player = GameUtils.getPlayer().orElseThrow();
        BlockPos pos = player.blockPosition();
        return WorldUtils.isChunkLoaded(player.level(), pos);
    }

    public void tick(Minecraft client) {
        if (!this.startupSoundPlayed) {
            this.handleStartupSound();
        }
        if (!this.doTick()) {
            return;
        }
        this.handlerTimer.begin();
        long tick = this.tickCount.getTickCount();
        for (AbstractClientHandler handler : this.effectHandlers) {
            long mark = System.nanoTime();
            if (handler.doTick(tick)) {
                handler.process(Handlers.getPlayer());
            }
            handler.updateTimer(System.nanoTime() - mark);
        }
        this.handlerTimer.end();
    }

    private void handleStartupSound() {
        Minecraft client = GameUtils.getMC();
        if (client.getOverlay() != null) {
            return;
        }
        this.startupSoundPlayed = true;
        this.soundLibrary.getRandomStartupSound().ifPresent(id -> {
            SimpleSoundInstance sound = SoundFactoryBuilder.create(id).build().createAsAdditional();
            this.audioPlayer.play((SoundInstance)sound);
        });
    }

    public void gatherDiagnostics(CollectDiagnosticsEvent event) {
        event.add(this.handlerTimer);
        this.effectHandlers.forEach(h -> {
            h.gatherDiagnostics(event);
            event.add(h.getTimer());
        });
    }

    public static void registerHandlers() {
        ContainerManager.getRootContainer().registerSingleton(CeilingScanner.class).registerSingleton(VillageScanner.class).registerSingleton(BiomeScanner.class).registerSingleton(Scanners.class).registerSingleton(EntityEffectHandler.class).registerSingleton(BiomeSoundHandler.class).registerSingleton(AreaBlockEffects.class).registerSingleton(FootstepAccents.class).registerSingleton(StepAccentGenerator.class).registerSingleton(FogHandler.class).registerSingleton(Handlers.class);
    }
}

