/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.accents;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.processing.accents.FootstepAccents;
import org.orecruncher.dsurround.processing.accents.IFootstepAccentProvider;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.tags.BlockEffectTags;

class WaterySurfaceAccent
implements IFootstepAccentProvider {
    private static final ResourceLocation WETSURFACE_FACTORY = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"footstep/wetsurface");
    private final Configuration config;

    WaterySurfaceAccent(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean isEnabled() {
        return this.config.footstepAccents.enableWetSurfaceAccents;
    }

    @Override
    public void collect(LivingEntity entity, BlockPos pos, BlockState state, boolean isWaterLogged, ObjectArray<ISoundFactory> acoustics) {
        BlockPos up;
        Level world;
        boolean addAcoustic = isWaterLogged;
        if (!addAcoustic) {
            addAcoustic = FootstepAccents.TAG_LIBRARY.is(BlockEffectTags.WATERY_STEP, state);
        }
        if (!addAcoustic && !(addAcoustic = FootstepAccents.TAG_LIBRARY.is(BlockEffectTags.WATERY_STEP, (world = entity.level()).getBlockState(up = pos.above()))) && world.isRainingAt(up)) {
            Biome.Precipitation precipitation = ((Biome)world.getBiome(up).value()).getPrecipitationAt(up);
            boolean bl = addAcoustic = precipitation == Biome.Precipitation.RAIN;
        }
        if (addAcoustic) {
            SOUND_LIBRARY.getSoundFactory(WETSURFACE_FACTORY).ifPresent(acoustics::add);
        }
    }
}

