/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import java.util.Iterator;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.processing.fog.VanillaFogRangeCalculator;

public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    private static final float SCALE_ADJUST = 0.002f;
    private final IBiomeLibrary biomeLibrary;
    private BlockPos lastBlockPos;
    private float activeScale;
    private float targetScale;

    public BiomeFogRangeCalculator(IBiomeLibrary biomeLibrary, Configuration.FogOptions fogOptions) {
        super("Biome", fogOptions);
        this.biomeLibrary = biomeLibrary;
        this.targetScale = 0.0f;
        this.activeScale = 0.0f;
        this.lastBlockPos = BlockPos.ZERO;
    }

    @Override
    public boolean enabled() {
        return this.fogOptions.enableBiomeFog;
    }

    @Override
    @NotNull
    public FogRenderer.FogData render(@NotNull FogRenderer.FogData data, float renderDistance, float partialTick) {
        if (Float.compare(this.activeScale, this.targetScale) != 0) {
            if (this.targetScale < this.activeScale) {
                this.activeScale -= 0.002f;
                if (this.activeScale < this.targetScale) {
                    this.activeScale = this.targetScale;
                }
            } else if (this.targetScale > this.activeScale) {
                this.activeScale += 0.002f;
                if (this.activeScale > this.targetScale) {
                    this.activeScale = this.targetScale;
                }
            }
        }
        if (Float.compare(this.activeScale, 0.0f) == 0) {
            return data;
        }
        float scale = 1.0f - this.activeScale;
        FogRenderer.FogData result = new FogRenderer.FogData(data.mode);
        result.end = data.end * scale;
        result.start = data.start * scale * scale;
        return result;
    }

    @Override
    public void tick() {
        BlockPos currentPosition = GameUtils.getPlayer().map(Entity::getOnPos).orElseThrow();
        if (this.lastBlockPos.equals((Object)currentPosition)) {
            return;
        }
        this.lastBlockPos = currentPosition;
        this.targetScale = this.sampleArea(currentPosition, 6);
    }

    @Override
    public void disconnect() {
        this.targetScale = 0.0f;
        this.activeScale = 0.0f;
        this.lastBlockPos = BlockPos.ZERO;
    }

    private float sampleArea(BlockPos pos, int range) {
        BiomeManager biomeManager = GameUtils.getWorld().map(Level::getBiomeManager).orElseThrow();
        Iterator iterator = BlockPos.withinManhattan((BlockPos)pos, (int)range, (int)range, (int)range).iterator();
        float intensityAccum = 0.0f;
        float intensityCount = 0.0f;
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            Biome b = (Biome)biomeManager.getNoiseBiomeAtPosition(p).value();
            BiomeInfo info = this.biomeLibrary.getBiomeInfo(b);
            intensityAccum += info.getFogDensity().getIntensity();
            intensityCount += 1.0f;
        }
        return intensityAccum / intensityCount;
    }
}

