/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.MinecraftClock;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.processing.fog.FogDensity;
import org.orecruncher.dsurround.processing.fog.VanillaFogRangeCalculator;

public class MorningFogRangeCalculator
extends VanillaFogRangeCalculator {
    private static final SimpleWeightedRandomList<FogDensity> SPRING_FOG = new SimpleWeightedRandomList.Builder().add((Object)FogDensity.NORMAL, 30).add((Object)FogDensity.MEDIUM, 20).add((Object)FogDensity.HEAVY, 10).build();
    private static final SimpleWeightedRandomList<FogDensity> SUMMER_FOG = new SimpleWeightedRandomList.Builder().add((Object)FogDensity.LIGHT, 20).add((Object)FogDensity.NONE, 10).build();
    private static final SimpleWeightedRandomList<FogDensity> AUTUMN_FOG = new SimpleWeightedRandomList.Builder().add((Object)FogDensity.NORMAL, 10).add((Object)FogDensity.MEDIUM, 20).add((Object)FogDensity.HEAVY, 10).build();
    private static final SimpleWeightedRandomList<FogDensity> WINTER_FOG = new SimpleWeightedRandomList.Builder().add((Object)FogDensity.LIGHT, 20).add((Object)FogDensity.NORMAL, 20).add((Object)FogDensity.MEDIUM, 10).build();
    protected final ISeasonalInformation seasonInfo;
    protected final MinecraftClock clock;
    protected int fogDay = -1;
    protected FogDensity type = FogDensity.NONE;

    public MorningFogRangeCalculator(ISeasonalInformation seasonInfo, Configuration.FogOptions fogOptions) {
        super("Morning", fogOptions);
        this.seasonInfo = seasonInfo;
        this.clock = new MinecraftClock();
    }

    @Override
    public boolean enabled() {
        return this.fogOptions.enableMorningFog;
    }

    @Override
    @NotNull
    public FogRenderer.FogData render(@NotNull FogRenderer.FogData data, float renderDistance, float partialTick) {
        float angle;
        if (this.type != FogDensity.NONE && this.type.inRange(angle = this.getCelestialAngleDegrees())) {
            float mid = (this.type.getStartAngle() + this.type.getEndAngle()) / 2.0f;
            float factor = (1.0f - Mth.abs((float)(angle - mid)) / (mid - this.type.getStartAngle())) * this.type.getIntensity();
            float shift = data.start * factor;
            float newEnd = data.end - shift;
            float newStart = Mth.clamp((float)(data.start - shift * 2.0f), (float)(this.type.getReserve() + 1.0f), (float)newEnd);
            FogRenderer.FogData result = new FogRenderer.FogData(data.mode);
            result.start = newStart;
            result.end = newEnd;
            return result;
        }
        return data;
    }

    @Override
    public void tick() {
        GameUtils.getWorld().ifPresent(this.clock::update);
        int day = this.clock.getDay();
        if (this.fogDay != day) {
            this.fogDay = day;
            this.type = this.isFogAllowed() ? this.getFogType() : FogDensity.NONE;
        }
    }

    @Override
    public void disconnect() {
        this.fogDay = -1;
        this.type = FogDensity.NONE;
    }

    private boolean isFogAllowed() {
        return GameUtils.getWorld().map(w -> w.dimensionType().natural()).orElse(false);
    }

    private float getCelestialAngleDegrees() {
        return GameUtils.getWorld().map(w -> Float.valueOf(w.getTimeOfDay(1.0f) * 360.0f)).orElseThrow().floatValue();
    }

    @NotNull
    protected FogDensity getFogType() {
        SimpleWeightedRandomList<FogDensity> selections;
        if (this.seasonInfo.isSpring()) {
            selections = SPRING_FOG;
        } else if (this.seasonInfo.isSummer()) {
            selections = SUMMER_FOG;
        } else if (this.seasonInfo.isAutumn()) {
            selections = AUTUMN_FOG;
        } else if (this.seasonInfo.isWinter()) {
            selections = WINTER_FOG;
        } else {
            return FogDensity.NONE;
        }
        return (FogDensity)((Object)selections.getRandomValue((RandomSource)Randomizer.current()).orElseThrow());
    }
}

