/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import net.minecraft.client.renderer.FogRenderer;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.processing.fog.VanillaFogRangeCalculator;

public class WeatherFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final float START_IMPACT = 0.9f;
    protected static final float END_IMPACT = 0.4f;

    protected WeatherFogRangeCalculator(Configuration.FogOptions fogOptions) {
        super("Weather", fogOptions);
    }

    @Override
    public boolean enabled() {
        return this.fogOptions.enableWeatherFog;
    }

    @Override
    @NotNull
    public FogRenderer.FogData render(@NotNull FogRenderer.FogData data, float renderDistance, float partialTick) {
        float rainStr = GameUtils.getWorld().map(w -> Float.valueOf(w.getRainLevel(partialTick))).orElseThrow().floatValue();
        if (rainStr > 0.0f) {
            float startScale = 1.0f - 0.9f * rainStr;
            float endScale = 1.0f - 0.4f * rainStr;
            FogRenderer.FogData result = new FogRenderer.FogData(data.mode);
            result.start = data.start * startScale;
            result.end = data.end * endScale;
            return result;
        }
        return data;
    }
}

