/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import org.orecruncher.dsurround.config.SyntheticBiome;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.processing.scanner.AbstractScanner;
import org.orecruncher.dsurround.processing.scanner.CeilingScanner;

public final class BiomeScanner
extends AbstractScanner {
    public static final int SCAN_INTERVAL = 4;
    private static final int UNDERGROUND_THRESHOLD_OFFSET = 8;
    private static final int SURVEY_HORIZONTAL_DIMENSION = 18;
    private static final int SURVEY_HORIZONTAL_OFFSET = 8;
    private static final int SURVEY_VERTICAL_DIMENSION = 16;
    private static final int SURVEY_VERTICAL_OFFSET = 3;
    private static final int MAX_SURVEY_VOLUME = 5184;
    private ResourceLocation surveyedDimension;
    private boolean isUnderWater;
    private BiomeInfo logicalBiomeInfo;
    private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    private int biomeArea;
    private Reference2IntOpenHashMap<BiomeInfo> weights = new Reference2IntOpenHashMap(8);
    private Biome surveyedBiome = null;
    private BlockPos surveyedPosition = BlockPos.ZERO;
    private final IBiomeLibrary biomeLibrary;
    private final IDimensionInformation dimensionInformation;
    private final CeilingScanner ceilingScanner;

    public BiomeScanner(IBiomeLibrary biomeLibrary, IDimensionInformation dimensionInformation, CeilingScanner ceilingScanner) {
        this.biomeLibrary = biomeLibrary;
        this.dimensionInformation = dimensionInformation;
        this.ceilingScanner = ceilingScanner;
    }

    public BiomeInfo playerLogicBiomeInfo() {
        return this.logicalBiomeInfo;
    }

    public ResourceLocation getDimInfo() {
        return this.surveyedDimension;
    }

    public boolean isUnderWater() {
        return this.isUnderWater;
    }

    @Override
    public void tick(long tickCount) {
        if (tickCount % 4L != 0L) {
            return;
        }
        Player player = GameUtils.getPlayer().orElseThrow();
        Level world = player.level();
        BlockPos position = player.blockPosition();
        BiomeManager biomes = world.getBiomeManager();
        Holder playerBiome = biomes.getBiome(position);
        if (this.surveyedBiome != playerBiome.value() || !this.surveyedDimension.equals((Object)this.dimensionInformation.name()) || !this.surveyedPosition.equals((Object)position)) {
            this.surveyedBiome = (Biome)playerBiome.value();
            this.surveyedPosition = position;
            this.surveyedDimension = this.dimensionInformation.name();
            this.weights = new Reference2IntOpenHashMap(8);
            this.isUnderWater = player.isEyeInFluid(FluidTags.WATER);
            if (this.isUnderWater) {
                BiomeInfo playerBiomeInfo = this.biomeLibrary.getBiomeInfo((Biome)playerBiome.value());
                SyntheticBiome internalBiome = playerBiomeInfo.isRiver() ? SyntheticBiome.UNDER_RIVER : (playerBiomeInfo.isDeepOcean() ? SyntheticBiome.UNDER_DEEP_OCEAN : (playerBiomeInfo.isOcean() ? SyntheticBiome.UNDER_OCEAN : SyntheticBiome.UNDER_WATER));
                this.logicalBiomeInfo = this.biomeLibrary.getBiomeInfo(internalBiome);
                this.biomeArea = 1;
                this.weights.addTo((Object)this.logicalBiomeInfo, 1);
                return;
            }
            this.logicalBiomeInfo = this.resolveBiome(biomes, position);
            for (int z = 0; z < 18; ++z) {
                int dZ = z - 8 + this.surveyedPosition.getZ();
                this.mutable.setZ(dZ);
                for (int x = 0; x < 18; ++x) {
                    int dX = x - 8 + this.surveyedPosition.getX();
                    this.mutable.setX(dX);
                    for (int y = 0; y < 16; ++y) {
                        int dY = y - 3 + this.surveyedPosition.getY();
                        this.mutable.setY(dY);
                        BiomeInfo info = this.resolveBiome(biomes, (BlockPos)this.mutable);
                        this.weights.addTo((Object)info, 1);
                    }
                }
            }
            this.biomeArea = 5184;
        }
    }

    private BiomeInfo resolveBiome(BiomeManager access, BlockPos pos) {
        Biome biome = (Biome)access.getBiome(pos).value();
        BiomeInfo biomeInfo = this.biomeLibrary.getBiomeInfo(biome);
        if (biomeInfo.isCave()) {
            return biomeInfo;
        }
        int y = pos.getY();
        if (y < this.dimensionInformation.seaLevel() - 8) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.UNDERGROUND);
        }
        if (!this.dimensionInformation.alwaysOutside() && this.ceilingScanner.isReallyInside()) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.INSIDE);
        }
        if (y >= this.dimensionInformation.getSpaceHeight()) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.SPACE);
        }
        if (y >= this.dimensionInformation.getCloudHeight()) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.CLOUDS);
        }
        return biomeInfo;
    }

    public int getBiomeArea() {
        return this.biomeArea;
    }

    public Reference2IntOpenHashMap<BiomeInfo> getBiomes() {
        return this.weights;
    }
}

