/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.config.DimensionInfo;
import org.orecruncher.dsurround.config.libraries.IDimensionLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.processing.scanner.AbstractScanner;

public final class CeilingScanner
extends AbstractScanner {
    private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    private static final int SURVEY_INTERVAL = 4;
    private static final int INSIDE_SURVEY_RANGE = 3;
    private static final float INSIDE_THRESHOLD = 0.6306818f;
    private static final Cell[] cells;
    private static final float TOTAL_POINTS;
    private static final ObjectArray<TagKey<Block>> NON_CEILING;
    private final IDimensionLibrary dimensionLibrary;
    private boolean reallyInside = false;
    private float coverageRatio = 0.0f;

    public CeilingScanner(IDimensionLibrary dimensionLibrary) {
        this.dimensionLibrary = dimensionLibrary;
    }

    @Override
    public void tick(long tickCount) {
        if (tickCount % 4L != 0L) {
            return;
        }
        ClientLevel world = GameUtils.getWorld().orElseThrow();
        DimensionInfo dimInfo = this.dimensionLibrary.getData((Level)world);
        if (dimInfo.alwaysOutside()) {
            this.reallyInside = false;
        } else {
            Player player = GameUtils.getPlayer().orElseThrow();
            BlockPos pos = player.blockPosition();
            float score = 0.0f;
            for (Cell cell : cells) {
                score += cell.score(pos);
            }
            this.coverageRatio = 1.0f - score / TOTAL_POINTS;
            this.reallyInside = this.coverageRatio > 0.6306818f;
        }
    }

    public boolean isReallyInside() {
        return this.reallyInside;
    }

    public float getCoverageRatio() {
        return this.coverageRatio;
    }

    static {
        NON_CEILING = new ObjectArray();
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                cellList.add(new Cell(new Vec3i(x, 0, z), 3));
            }
        }
        Collections.sort(cellList);
        cells = cellList.toArray(new Cell[0]);
        float totalPoints = 0.0f;
        for (Cell c : cellList) {
            totalPoints += c.potentialPoints();
        }
        TOTAL_POINTS = totalPoints;
        NON_CEILING.add((TagKey<Block>)BlockTags.LEAVES);
        NON_CEILING.add((TagKey<Block>)BlockTags.FENCE_GATES);
        NON_CEILING.add((TagKey<Block>)BlockTags.FENCES);
        NON_CEILING.add((TagKey<Block>)BlockTags.WALLS);
    }

    private static final class Cell
    implements Comparable<Cell> {
        private final Vec3i offset;
        private final float points;
        private final BlockPos.MutableBlockPos working;

        public Cell(Vec3i offset, int range) {
            this.offset = offset;
            float xV = range - Math.abs(offset.getX()) + 1;
            float zV = range - Math.abs(offset.getZ()) + 1;
            float candidate = Math.min(xV, zV);
            this.points = candidate * candidate;
            this.working = new BlockPos.MutableBlockPos();
        }

        public float potentialPoints() {
            return this.points;
        }

        public float score(BlockPos playerPos) {
            this.working.set(playerPos.getX() + this.offset.getX(), playerPos.getY() + this.offset.getY(), playerPos.getZ() + this.offset.getZ());
            Level world = (Level)GameUtils.getWorld().orElseThrow();
            int playerHeight = Math.max(playerPos.getY() + 1, 0);
            this.working.setY(WorldUtils.getPrecipitationHeight(world, (BlockPos)this.working));
            while (this.working.getY() > playerHeight) {
                BlockState state = world.getBlockState((BlockPos)this.working);
                if (this.actsAsCeiling(state)) {
                    return 0.0f;
                }
                this.working.setY(this.working.getY() - 1);
            }
            return this.points;
        }

        @Override
        public int compareTo(Cell cell) {
            return -Float.compare(this.potentialPoints(), cell.potentialPoints());
        }

        public String toString() {
            return this.offset.toString() + " points: " + this.points;
        }

        private boolean actsAsCeiling(BlockState state) {
            if (!state.blocksMotion()) {
                return false;
            }
            for (TagKey<Block> tag : NON_CEILING) {
                if (!TAG_LIBRARY.is(tag, state)) continue;
                return false;
            }
            return true;
        }
    }
}

