/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IEffectSystem;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.Cacheable;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scanner.CuboidScanner;
import org.orecruncher.dsurround.lib.scanner.ScanContext;

@Cacheable
public class SystemsScanner
extends CuboidScanner {
    private static final Predicate<IBlockEffect> EFFECT_PREDICATE = system -> {
        system.tick();
        return system.isDone();
    };
    private final Configuration config;
    private final ObjectArray<IEffectSystem> systems = new ObjectArray();
    private int lastRange;

    public SystemsScanner(Configuration config, ScanContext locus) {
        super(locus, "SystemsScanner", config.blockEffects.blockEffectRange);
        this.config = config;
        this.lastRange = config.blockEffects.blockEffectRange;
    }

    public void addEffectSystem(IEffectSystem system) {
        this.systems.add(system);
    }

    @Override
    public void resetFullScan() {
        super.resetFullScan();
        this.systems.forEach(IEffectSystem::clear);
    }

    @Override
    public void tick() {
        Predicate<IBlockEffect> filter;
        super.tick();
        if (this.lastRange != this.config.blockEffects.blockEffectRange) {
            this.lastRange = this.config.blockEffects.blockEffectRange;
            this.setRange(this.lastRange);
            return;
        }
        Player player = GameUtils.getPlayer().orElseThrow();
        BlockPos current = player.blockPosition();
        boolean sittingStill = this.lastPos.equals((Object)current);
        this.lastPos = current;
        if (!sittingStill) {
            int range = this.config.blockEffects.blockEffectRange;
            BlockBox blockBox = BlockBox.of((BlockPos)current.offset(-range, -range, -range), (BlockPos)current.offset(range, range, range));
            filter = system -> {
                if (blockBox.contains(system.getPos())) {
                    system.tick();
                } else {
                    system.remove();
                }
                return system.isDone();
            };
        } else {
            filter = EFFECT_PREDICATE;
        }
        this.processIfEnabled(true, system -> system.tick(filter));
    }

    protected void processIfEnabled(boolean clearSystems, Consumer<IEffectSystem> systemConsumer) {
        for (IEffectSystem system : this.systems) {
            if (system.isEnabled()) {
                systemConsumer.accept(system);
                continue;
            }
            if (!clearSystems) continue;
            system.clear();
        }
    }

    @Override
    public boolean doBlockUnscan() {
        return true;
    }

    @Override
    public void blockScan(Level world, BlockState state, BlockPos pos, IRandomizer rand) {
        this.processIfEnabled(false, system -> system.blockScan(world, state, pos));
    }

    @Override
    public void blockUnscan(Level world, BlockState state, BlockPos pos, IRandomizer rand) {
        this.processIfEnabled(false, system -> system.blockUnscan(world, state, pos));
    }

    public void gatherDiagnostics(Collection<Component> output) {
        this.systems.forEach(system -> {
            Object text = system.gatherDiagnostics();
            if (!system.isEnabled()) {
                text = (String)text + " (disabled)";
            }
            output.add((Component)Component.literal((String)text));
        });
    }
}

