/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Position;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.processing.scanner.AbstractScanner;

public class VillageScanner
extends AbstractScanner {
    private static final double VILLAGE_RANGE = 64.0;
    private static final int SCAN_INTERVAL = 20;
    private boolean isInVillage;

    @Override
    public void tick(long tickCount) {
        Vec3 playerEyes;
        AABB box;
        List villagerEntities;
        if (tickCount % 20L != 0L) {
            return;
        }
        this.isInVillage = false;
        ClientLevel world = GameUtils.getWorld().orElseThrow();
        Player player = GameUtils.getPlayer().orElseThrow();
        if (world.dimensionType().natural() && !(villagerEntities = world.getEntitiesOfClass(Villager.class, box = AABB.unitCubeFromLowerCorner((Vec3)(playerEyes = player.getEyePosition())).inflate(64.0))).isEmpty()) {
            List<BlockEntity> bell = WorldUtils.getLoadedBlockEntities((Level)world, blockEntity -> blockEntity instanceof BellBlockEntity && blockEntity.getBlockPos().closerToCenterThan((Position)playerEyes, 64.0));
            this.isInVillage = !bell.isEmpty();
        }
    }

    public boolean isInVillage() {
        return this.isInVillage;
    }
}

