/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.Listener;
import dev.architectury.platform.Platform;
import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC11;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.mixins.audio.MixinSoundEngineAccessor;
import org.orecruncher.dsurround.mixins.audio.MixinSoundManagerAccessor;
import org.orecruncher.dsurround.mixins.core.MixinAbstractSoundInstance;
import org.orecruncher.dsurround.mixinutils.ISoundEngine;
import org.orecruncher.dsurround.runtime.audio.SoundFXProcessor;

public final class AudioUtilities {
    private static final IModLog LOGGER = ContainerManager.resolve(IModLog.class);
    private static final ObjectArray<String> autoDisabledBecauseOf = new ObjectArray();
    private static final Lazy<Boolean> advancedProcessingEnabled = new Lazy<Boolean>(() -> {
        Configuration.EnhancedSounds config = ContainerManager.resolve(Configuration.EnhancedSounds.class);
        if (config.enableEnhancedSounds) {
            for (String modId : autoDisabledBecauseOf) {
                if (!Platform.isModLoaded((String)modId)) continue;
                LOGGER.warn("Enhanced sound processing is auto disabled due to the presence of the mod \"%s\"", modId);
                return false;
            }
            return true;
        }
        return false;
    });
    private static int MAX_SOUNDS = 0;
    private static final ThreadLocal<StringBuilder> builder;

    public static int getMaxSounds() {
        return MAX_SOUNDS;
    }

    public static SoundEngine getSoundSystem() {
        SoundManager soundManager = GameUtils.getSoundManager();
        MixinSoundManagerAccessor manager = (MixinSoundManagerAccessor)soundManager;
        return manager.dsurround_getSoundSystem();
    }

    public static Listener getSoundListener() {
        return ((MixinSoundEngineAccessor)AudioUtilities.getSoundSystem()).dsurround_getListener();
    }

    public static String debugString(SoundInstance sound) {
        try {
            StringBuilder sb = builder.get();
            sb.setLength(0);
            MixinAbstractSoundInstance accessor = (MixinAbstractSoundInstance)sound;
            sb.append(sound.getClass().getSimpleName()).append("{");
            sb.append(sound.getLocation());
            sb.append(", ").append(sound.getSource().getName());
            sb.append(", ").append(sound.getAttenuation());
            sb.append(String.format(", (%.2f,%.2f,%.2f)", sound.getX(), sound.getY(), sound.getZ()));
            Sound underlyingSound = sound.getSound();
            if (underlyingSound != null) {
                sb.append(String.format(", v: %.4f(%.4f)", Float.valueOf(sound.getVolume()), Float.valueOf(accessor.dsurround_getRawVolume())));
                sb.append(String.format(", p: %.4f(%.4f)", Float.valueOf(sound.getPitch()), Float.valueOf(accessor.dsurround_getRawPitch())));
                sb.append(", s: ").append(sound.getSound().shouldStream());
            }
            sb.append(", g: ").append(sound.isRelative());
            sb.append("}");
            if (!sound.isRelative()) {
                Listener listener = AudioUtilities.getSoundListener();
                double distance = Math.sqrt(listener.getTransform().position().distanceToSqr(sound.getX(), sound.getY(), sound.getZ()));
                sb.append(String.format(", distance: %.1f", distance));
                if (underlyingSound != null) {
                    sb.append(" (").append(underlyingSound.getAttenuationDistance()).append(")");
                }
            }
            return sb.toString();
        }
        catch (Throwable throwable) {
            return "Unable to format sound!";
        }
    }

    public static void initialize(Library soundEngine) {
        try {
            long devicePointer = ((ISoundEngine)soundEngine).dsurround_getDevicePointer();
            MAX_SOUNDS = ALC11.alcGetInteger((long)devicePointer, (int)4112);
            if (AudioUtilities.doEnhancedSounds()) {
                SoundFXProcessor.initialize();
            } else {
                LOGGER.warn("Enhanced sound processing is disabled", new Object[0]);
            }
            String vendor = AL10.alGetString((int)45057);
            String version = AL10.alGetString((int)45058);
            String renderer = AL10.alGetString((int)45059);
            String extensions = AL10.alGetString((int)45060);
            int frequency = ALC11.alcGetInteger((long)devicePointer, (int)4103);
            int auxSendsConfigured = ALC11.alcGetInteger((long)devicePointer, (int)131075);
            LOGGER.info("Vendor: %s", vendor);
            LOGGER.info("Version: %s", version);
            LOGGER.info("Renderer: %s", renderer);
            LOGGER.info("Frequency: %d", frequency);
            LOGGER.info("AuxSends: %d", auxSendsConfigured);
            LOGGER.info("Extensions: %s", extensions);
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), new Object[0]);
            LOGGER.warn("OpenAL special effects for sounds will not be available", new Object[0]);
        }
    }

    public static boolean doEnhancedSounds() {
        return (Boolean)advancedProcessingEnabled.get();
    }

    public static void deinitialize(Library ignore) {
        if (AudioUtilities.doEnhancedSounds()) {
            SoundFXProcessor.deinitialize();
        }
    }

    public static void onSoundPlay(SoundInstance sound) {
        LOGGER.debug(2, () -> "PLAYING: " + AudioUtilities.debugString(sound));
    }

    public static int execute(Runnable func, @Nullable Supplier<String> context) {
        func.run();
        int error = AL10.alGetError();
        if (error != 0) {
            String errorName = AL10.alGetString((int)error);
            if (StringUtils.isEmpty((CharSequence)errorName)) {
                errorName = Integer.toString(error);
            }
            String msg = null;
            if (context != null) {
                msg = context.get();
            }
            if (msg == null) {
                msg = "NONE";
            }
            LOGGER.warn(String.format("OpenAL Error: %s [%s]", errorName, msg), new Object[0]);
        }
        return error;
    }

    public static void validate(String msg) {
        AudioUtilities.validate(() -> msg);
    }

    public static void validate(@Nullable Supplier<String> err) {
        int error = AL10.alGetError();
        if (error != 0) {
            String errorName = AL10.alGetString((int)error);
            if (StringUtils.isEmpty((CharSequence)errorName)) {
                errorName = Integer.toString(error);
            }
            String msg = null;
            if (err != null) {
                msg = err.get();
            }
            if (msg == null) {
                msg = "NONE";
            }
            throw new IllegalStateException(String.format("OpenAL Error: %s [%s]", errorName, msg));
        }
    }

    static {
        autoDisabledBecauseOf.add("sound_physics_remastered");
        builder = ThreadLocal.withInitial(() -> new StringBuilder(128));
    }
}

