/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import com.mojang.blaze3d.audio.SoundBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.mixins.audio.MixinSoundBuffer;

public final class Conversion {
    public static AudioStream convert(AudioStream inputStream) {
        AudioFormat format = inputStream.getFormat();
        if (format.getChannels() == 1) {
            return inputStream;
        }
        return new MonoStream(inputStream);
    }

    public static void convert(SoundBuffer buffer) {
        MixinSoundBuffer accessor = (MixinSoundBuffer)buffer;
        AudioFormat format = accessor.dsurround_getFormat();
        if (format.getChannels() == 1) {
            return;
        }
        int bits = format.getSampleSizeInBits();
        if (bits != 8 && bits != 16) {
            return;
        }
        boolean bigendian = format.isBigEndian();
        AudioFormat monoformat = new AudioFormat(format.getEncoding(), format.getSampleRate(), bits, 1, format.getFrameSize() >> 1, format.getFrameRate(), bigendian);
        ByteBuffer source = accessor.dsurround_getSample();
        if (source == null) {
            return;
        }
        int sourceLength = source.limit();
        int skip = format.getFrameSize();
        for (int i = 0; i < sourceLength; i += skip) {
            int v;
            int c2;
            int c1;
            int targetIdx = i >> 1;
            if (bits == 8) {
                c1 = source.get(i) >> 1;
                c2 = source.get(i + 1) >> 1;
                v = c1 + c2;
                source.put(targetIdx, (byte)v);
                continue;
            }
            c1 = source.getShort(i) >> 1;
            c2 = source.getShort(i + 2) >> 1;
            v = c1 + c2;
            source.putShort(targetIdx, (short)v);
        }
        accessor.dsurround_setFormat(monoformat);
        source.rewind();
        source.limit(sourceLength >> 1);
    }

    private record MonoStream(AudioStream source) implements AudioStream
    {
        @NotNull
        public AudioFormat getFormat() {
            return this.source.getFormat();
        }

        @NotNull
        public ByteBuffer read(int i) throws IOException {
            return this.source.read(i);
        }

        public void close() throws IOException {
            this.source.close();
        }
    }
}

