/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.SoundBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.Singleton;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.threading.Worker;
import org.orecruncher.dsurround.mixinutils.IChannelHandle;
import org.orecruncher.dsurround.mixinutils.ISourceContext;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.runtime.audio.Conversion;
import org.orecruncher.dsurround.runtime.audio.SourceContext;
import org.orecruncher.dsurround.runtime.audio.WorldContext;
import org.orecruncher.dsurround.runtime.audio.effects.Effects;

public final class SoundFXProcessor {
    private static final IModLog LOGGER = ContainerManager.resolve(IModLog.class);
    private static final int SOUND_PROCESS_ITERATION = 50;
    static boolean isAvailable;
    private static SourceContext[] sources;
    private static Worker soundProcessor;
    private static String diagnosticString;
    private static final Singleton<ExecutorService> threadPool;
    private static WorldContext worldContext;

    public static WorldContext getWorldContext() {
        return worldContext;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static void initialize() {
        Effects.initialize();
        sources = new SourceContext[AudioUtilities.getMaxSounds()];
        if (soundProcessor == null) {
            soundProcessor = new Worker("Enhanced Sound Processor", SoundFXProcessor::processSounds, 50, LOGGER);
            soundProcessor.start();
        }
        isAvailable = true;
    }

    public static void deinitialize() {
        if (SoundFXProcessor.isAvailable()) {
            isAvailable = false;
            if (soundProcessor != null) {
                soundProcessor.stop();
                soundProcessor = null;
            }
            if (sources != null) {
                Arrays.fill(sources, null);
                sources = null;
            }
            Effects.deinitialize();
        }
    }

    private static boolean shouldIgnoreSound(SoundInstance sound) {
        return sound.isRelative() || sound.getAttenuation() == SoundInstance.Attenuation.NONE || sound.getSource() == SoundSource.MASTER || sound.getSource() == SoundSource.MUSIC || sound.getSource() == SoundSource.WEATHER;
    }

    public static void onSoundPlay(SoundInstance sound, ChannelAccess.ChannelHandle entry) {
        if (!SoundFXProcessor.isAvailable()) {
            return;
        }
        if (SoundFXProcessor.shouldIgnoreSound(sound)) {
            return;
        }
        ISourceContext source = (ISourceContext)((IChannelHandle)entry).dsurround_getSource();
        assert (source != null);
        int id = source.dsurround_getId();
        if (id > 0) {
            SourceContext ctx = new SourceContext(id);
            ctx.attachSound(sound);
            ctx.enable();
            source.dsurround_setData(ctx);
        }
    }

    public static void onSourcePlay(Channel source) {
        ISourceContext context = (ISourceContext)source;
        Optional<SourceContext> data = context.dsurround_getData();
        data.ifPresent(ctx -> {
            int id = ctx.getId();
            ctx.exec();
            SoundFXProcessor.sources[id - 1] = ctx;
        });
    }

    public static void tick(Channel source) {
        ISourceContext src = (ISourceContext)source;
        Optional<SourceContext> data = src.dsurround_getData();
        data.ifPresent(SourceContext::tick);
    }

    public static void stopSoundPlay(Channel source) {
        ISourceContext sourceContext = (ISourceContext)source;
        Optional<SourceContext> data = sourceContext.dsurround_getData();
        data.ifPresent(sc -> {
            SoundFXProcessor.sources[sc.getId() - 1] = null;
        });
    }

    public static void doMonoConversion(Channel source, SoundBuffer buffer) {
        if (!Client.Config.enhancedSounds.enableMonoConversion) {
            return;
        }
        Optional<SourceContext> data = ((ISourceContext)source).dsurround_getData();
        data.ifPresent(ctx -> {
            SoundInstance s = ctx.getSound();
            if (s != null && s.getAttenuation() != SoundInstance.Attenuation.NONE && !s.isRelative()) {
                Conversion.convert(buffer);
            }
        });
    }

    public static void clientTick(Minecraft client) {
        if (SoundFXProcessor.isAvailable()) {
            worldContext = new WorldContext();
        }
    }

    private static void processSounds() {
        try {
            ExecutorService pool = threadPool.get();
            assert (pool != null);
            ObjectArray<Future> tasks = new ObjectArray<Future>(sources.length);
            for (SourceContext ctx : sources) {
                if (ctx == null || !ctx.shouldExecute()) continue;
                tasks.add(pool.submit(ctx));
            }
            diagnosticString = "(ticked: %d)".formatted(tasks.size());
            tasks.forEach(task -> {
                try {
                    task.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error in SoundContext ForkJoinPool", new Object[0]);
        }
    }

    private static void onGatherText(CollectDiagnosticsEvent event) {
        if (SoundFXProcessor.isAvailable() && soundProcessor != null) {
            String msg = soundProcessor.getDiagnosticString() + " " + diagnosticString;
            event.add(CollectDiagnosticsEvent.Section.Systems, msg);
        } else {
            event.getSectionText(CollectDiagnosticsEvent.Section.Systems).add((Component)Component.literal((String)"Enhanced sound processing disabled"));
        }
    }

    static {
        diagnosticString = "";
        threadPool = new Singleton<Supplier<ExecutorService>>(() -> {
            Configuration.EnhancedSounds config = ContainerManager.resolve(Configuration.EnhancedSounds.class);
            int threads = config.backgroundThreadWorkers;
            if (threads == 0) {
                threads = 2;
            }
            LOGGER.info("Threads allocated to enhanced sound processor: %d", threads);
            return Executors.newFixedThreadPool(threads);
        });
        worldContext = new WorldContext();
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(SoundFXProcessor::onGatherText);
        ClientState.TICK_START.register(SoundFXProcessor::clientTick);
    }
}

