/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.math.MathStuff;
import org.orecruncher.dsurround.lib.math.ReusableRaycastContext;
import org.orecruncher.dsurround.lib.math.ReusableRaycastIterator;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.runtime.audio.SourceContext;
import org.orecruncher.dsurround.runtime.audio.WorldContext;
import org.orecruncher.dsurround.runtime.audio.effects.LowPassData;
import org.orecruncher.dsurround.runtime.audio.effects.SourcePropertyFloat;
import org.orecruncher.dsurround.sound.SoundInstanceHandler;

public final class SoundFXUtils {
    private static final IBlockLibrary BLOCK_LIBRARY = ContainerManager.resolve(IBlockLibrary.class);
    private static final ISeasonalInformation SEASONAL_INFORMATION = ContainerManager.resolve(ISeasonalInformation.class);
    private static final Configuration.EnhancedSounds CONFIG = ContainerManager.resolve(Configuration.EnhancedSounds.class);
    private static final int OCCLUSION_SEGMENTS = 5;
    private static final int REVERB_RAYS = SoundFXUtils.CONFIG.reverbRays;
    private static final int REVERB_RAY_BOUNCES = SoundFXUtils.CONFIG.reverbBounces;
    private static final float MAX_REVERB_DISTANCE = SoundFXUtils.CONFIG.reverbRayTraceDistance;
    private static final float RECIP_TOTAL_RAYS = 1.0f / (float)(REVERB_RAYS * REVERB_RAY_BOUNCES);
    private static final float ENERGY_COEFF = 0.1875f * RECIP_TOTAL_RAYS;
    private static final float ENERGY_CONST = 0.0625f * RECIP_TOTAL_RAYS;
    private static final Vec3[] REVERB_RAY_NORMALS = new Vec3[REVERB_RAYS];
    private static final Vec3[] REVERB_RAY_PROJECTED = new Vec3[REVERB_RAYS];
    private static final Vec3[] SURFACE_DIRECTION_NORMALS = new Vec3[Direction.values().length];
    private final SourceContext source;

    public SoundFXUtils(SourceContext source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate(@NotNull WorldContext ctx) {
        assert (ctx.player != null);
        assert (ctx.world != null);
        assert (this.source.getSound() != null);
        if (ctx.isNotValid() || !this.source.isEnabled() || !SoundInstanceHandler.inRange(ctx.playerEyePosition, this.source.getSound()) || this.source.getPosition().equals((Object)Vec3.ZERO)) {
            this.clearSettings();
            return;
        }
        Vec3 soundPos = SoundFXUtils.offsetPositionIfSolid(ctx.world, this.source.getPosition(), ctx.playerEyePosition);
        float absorptionCoeff = 3.0f;
        float airAbsorptionFactor = SoundFXUtils.calculateWeatherAbsorption(ctx, soundPos, ctx.playerEyePosition);
        float occlusionAccumulation = this.calculateOcclusion(ctx, soundPos, ctx.playerEyePosition);
        float sendCoeff = -occlusionAccumulation * 3.0f;
        float directCutoff = (float)MathStuff.exp(sendCoeff);
        directCutoff *= 1.0f - ctx.auralDampening;
        float sendGain0 = 0.0f;
        float sendGain1 = 0.0f;
        float sendGain2 = 0.0f;
        float sendGain3 = 0.0f;
        float[] bounceRatio = new float[REVERB_RAY_BOUNCES];
        float sharedAirspace = 0.0f;
        ReusableRaycastContext traceContext = new ReusableRaycastContext(ctx.world, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY);
        block3: for (int i = 0; i < REVERB_RAYS; ++i) {
            Vec3 origin = soundPos;
            Vec3 target = origin.add(REVERB_RAY_PROJECTED[i]);
            BlockHitResult rayHit = traceContext.trace(origin, target);
            if (SoundFXUtils.isMiss(rayHit)) continue;
            BlockPos lastHitBlock = rayHit.getBlockPos();
            Vec3 lastHitPos = rayHit.getLocation();
            Vec3 lastHitNormal = SoundFXUtils.surfaceNormal(rayHit.getDirection());
            Vec3 lastRayDir = REVERB_RAY_NORMALS[i];
            double totalRayDistance = origin.distanceTo(rayHit.getLocation());
            for (int j = 0; j < REVERB_RAY_BOUNCES; ++j) {
                float blockReflectivity = SoundFXUtils.getReflectivity(ctx.world.getBlockState(lastHitBlock));
                float energyTowardsPlayer = blockReflectivity * ENERGY_COEFF + ENERGY_CONST;
                Vec3 newRayDir = MathStuff.reflection(lastRayDir, lastHitNormal);
                origin = MathStuff.addScaled(lastHitPos, newRayDir, 0.01f);
                rayHit = traceContext.trace(origin, target = MathStuff.addScaled(origin, newRayDir, MAX_REVERB_DISTANCE));
                boolean missed = SoundFXUtils.isMiss(rayHit);
                if (missed) {
                    totalRayDistance += lastHitPos.distanceTo(ctx.playerEyePosition);
                } else {
                    int n = j;
                    bounceRatio[n] = bounceRatio[n] + blockReflectivity;
                    totalRayDistance += lastHitPos.distanceTo(rayHit.getLocation());
                    lastHitPos = rayHit.getLocation();
                    lastHitNormal = SoundFXUtils.surfaceNormal(rayHit.getDirection());
                    lastRayDir = newRayDir;
                    lastHitBlock = rayHit.getBlockPos();
                    Vec3 finalRayStart = MathStuff.addScaled(lastHitPos, lastHitNormal, 0.01f);
                    BlockHitResult finalRayHit = traceContext.trace(finalRayStart, ctx.playerEyePosition);
                    if (SoundFXUtils.isMiss(finalRayHit)) {
                        sharedAirspace += 1.0f;
                    }
                }
                assert (totalRayDistance >= 0.0);
                float reflectionDelay = (float)totalRayDistance * 0.12f * blockReflectivity;
                float cross0 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 0.0f));
                float cross1 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 1.0f));
                float cross2 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 2.0f));
                float cross3 = MathStuff.clamp1(reflectionDelay - 2.0f);
                sendGain0 += cross0 * energyTowardsPlayer * 6.4f;
                sendGain1 += cross1 * energyTowardsPlayer * 12.8f;
                sendGain2 += cross2 * energyTowardsPlayer * 12.8f;
                sendGain3 += cross3 * energyTowardsPlayer * 12.8f;
                if (missed) continue block3;
            }
        }
        bounceRatio[0] = bounceRatio[0] / (float)REVERB_RAYS;
        bounceRatio[1] = bounceRatio[1] / (float)REVERB_RAYS;
        bounceRatio[2] = bounceRatio[2] / (float)REVERB_RAYS;
        bounceRatio[3] = bounceRatio[3] / (float)REVERB_RAYS;
        float sharedAirspaceWeight0 = MathStuff.clamp1((sharedAirspace *= RECIP_TOTAL_RAYS * 64.0f) / 20.0f);
        float sharedAirspaceWeight1 = MathStuff.clamp1(sharedAirspace / 15.0f);
        float sharedAirspaceWeight2 = MathStuff.clamp1(sharedAirspace / 10.0f);
        float sharedAirspaceWeight3 = MathStuff.clamp1(sharedAirspace / 10.0f);
        float exp1 = (float)MathStuff.exp(sendCoeff);
        float exp2 = (float)MathStuff.exp(sendCoeff * 1.5f);
        float sendCutoff0 = exp1 * (1.0f - sharedAirspaceWeight0) + sharedAirspaceWeight0;
        float sendCutoff1 = exp1 * (1.0f - sharedAirspaceWeight1) + sharedAirspaceWeight1;
        float sendCutoff2 = exp2 * (1.0f - sharedAirspaceWeight2) + sharedAirspaceWeight2;
        float sendCutoff3 = exp2 * (1.0f - sharedAirspaceWeight3) + sharedAirspaceWeight3;
        float averageSharedAirspace = (sharedAirspaceWeight0 + sharedAirspaceWeight1 + sharedAirspaceWeight2 + sharedAirspaceWeight3) * 0.25f;
        directCutoff = Math.max((float)Math.sqrt(averageSharedAirspace) * 0.2f, directCutoff);
        float directGain = (float)MathStuff.pow(directCutoff, 0.1);
        sendGain1 *= bounceRatio[1];
        sendGain2 *= (float)MathStuff.pow(bounceRatio[2], 3.0);
        sendGain3 *= (float)MathStuff.pow(bounceRatio[3], 4.0);
        sendGain0 = MathStuff.clamp1(sendGain0);
        sendGain1 = MathStuff.clamp1(sendGain1);
        sendGain2 = MathStuff.clamp1(sendGain2 * 1.05f - 0.05f);
        sendGain3 = MathStuff.clamp1(sendGain3 * 1.05f - 0.05f);
        sendGain0 *= (float)MathStuff.pow(sendCutoff0, 0.1);
        sendGain1 *= (float)MathStuff.pow(sendCutoff1, 0.1);
        sendGain2 *= (float)MathStuff.pow(sendCutoff2, 0.1);
        sendGain3 *= (float)MathStuff.pow(sendCutoff3, 0.1);
        if (ctx.player.isUnderWater()) {
            sendCutoff0 *= 0.4f;
            sendCutoff1 *= 0.4f;
            sendCutoff2 *= 0.4f;
            sendCutoff3 *= 0.4f;
        }
        LowPassData lp0 = this.source.getLowPass0();
        LowPassData lp1 = this.source.getLowPass1();
        LowPassData lp2 = this.source.getLowPass2();
        LowPassData lp3 = this.source.getLowPass3();
        LowPassData direct = this.source.getDirect();
        SourcePropertyFloat prop = this.source.getAirAbsorb();
        Object object = this.source.sync();
        synchronized (object) {
            lp0.gain = sendGain0;
            lp0.gainHF = sendCutoff0;
            lp0.setProcess(true);
            lp1.gain = sendGain1;
            lp1.gainHF = sendCutoff1;
            lp1.setProcess(true);
            lp2.gain = sendGain2;
            lp2.gainHF = sendCutoff2;
            lp2.setProcess(true);
            lp3.gain = sendGain3;
            lp3.gainHF = sendCutoff3;
            lp3.setProcess(true);
            direct.gain = directGain;
            direct.gainHF = directCutoff;
            direct.setProcess(true);
            prop.setValue(airAbsorptionFactor);
            prop.setProcess(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSettings() {
        Object object = this.source.sync();
        synchronized (object) {
            this.source.getLowPass0().setProcess(false);
            this.source.getLowPass1().setProcess(false);
            this.source.getLowPass2().setProcess(false);
            this.source.getLowPass3().setProcess(false);
            this.source.getDirect().setProcess(false);
            this.source.getAirAbsorb().setProcess(false);
        }
    }

    private float calculateOcclusion(WorldContext ctx, Vec3 origin, Vec3 target) {
        if (SoundFXUtils.skipOcclusion(this.source.getCategory())) {
            return 0.0f;
        }
        assert (ctx.world != null);
        assert (ctx.player != null);
        float factor = 0.0f;
        Vec3 lastHit = origin;
        BlockState lastState = ctx.world.getBlockState(BlockPos.containing((double)lastHit.x(), (double)lastHit.y(), (double)lastHit.z()));
        ReusableRaycastContext traceContext = new ReusableRaycastContext(ctx.world, origin, target, ClipContext.Block.VISUAL, ClipContext.Fluid.ANY);
        ReusableRaycastIterator itr = new ReusableRaycastIterator(traceContext);
        for (int i = 0; i < 5 && itr.hasNext(); ++i) {
            BlockHitResult result = itr.next();
            float occlusion = SoundFXUtils.getOcclusion(lastState);
            double distance = lastHit.distanceTo(result.getLocation());
            factor += (float)((double)occlusion * distance);
            lastHit = result.getLocation();
            lastState = ctx.world.getBlockState(result.getBlockPos());
        }
        return factor;
    }

    private static float calculateWeatherAbsorption(WorldContext ctx, Vec3 pt1, Vec3 pt2) {
        assert (ctx.world != null);
        if (!ctx.isPrecipitating) {
            return 1.0f;
        }
        BlockPos low = BlockPos.containing((Position)pt1);
        BlockPos mid = BlockPos.containing((Position)MathStuff.addScaled(pt1, pt2, 0.5));
        BlockPos high = BlockPos.containing((Position)pt2);
        Biome.Precipitation rt1 = SEASONAL_INFORMATION.getActivePrecipitation(low);
        Biome.Precipitation rt2 = SEASONAL_INFORMATION.getActivePrecipitation(mid);
        Biome.Precipitation rt3 = SEASONAL_INFORMATION.getActivePrecipitation(high);
        float factor = SoundFXUtils.calcFactor(rt1, 0.25f);
        factor += SoundFXUtils.calcFactor(rt2, 0.5f);
        factor += SoundFXUtils.calcFactor(rt3, 0.25f);
        return factor *= ctx.precipitationStrength;
    }

    private static float getReflectivity(BlockState state) {
        return BLOCK_LIBRARY.getBlockInfoWeak(state).getSoundReflectivity();
    }

    private static float getOcclusion(BlockState state) {
        return BLOCK_LIBRARY.getBlockInfoWeak(state).getSoundOcclusion();
    }

    private static Vec3 surfaceNormal(Direction d) {
        return SURFACE_DIRECTION_NORMALS[d.ordinal()];
    }

    private static Vec3 offsetPositionIfSolid(Level world, Vec3 origin, Vec3 target) {
        if (world.getBlockState(BlockPos.containing((Position)origin)) != Blocks.AIR.defaultBlockState()) {
            Vec3 normal = origin.vectorTo(target).normalize();
            return MathStuff.addScaled(origin, normal, 0.876f);
        }
        return origin;
    }

    private static float calcFactor(Biome.Precipitation type, float base) {
        return type == Biome.Precipitation.NONE ? base : base * (type == Biome.Precipitation.SNOW ? 5.0f : 2.0f);
    }

    private static boolean isMiss(@Nullable BlockHitResult result) {
        return result == null || result.getType() == HitResult.Type.MISS;
    }

    private static boolean skipOcclusion(SoundSource category) {
        return !SoundFXUtils.CONFIG.enableOcclusionProcessing || category == SoundSource.MASTER || category == SoundSource.MUSIC;
    }

    static {
        for (Direction d : Direction.values()) {
            SoundFXUtils.SURFACE_DIRECTION_NORMALS[d.ordinal()] = Vec3.atLowerCornerOf((Vec3i)d.getNormal());
        }
        for (int i = 0; i < REVERB_RAYS; ++i) {
            double longitude = MathStuff.ANGLE * (double)i;
            double latitude = Math.asin((double)i / (double)REVERB_RAYS * 2.0 - 1.0);
            SoundFXUtils.REVERB_RAY_NORMALS[i] = new Vec3(Math.cos(latitude) * Math.cos(longitude), Math.cos(latitude) * Math.sin(longitude), Math.sin(latitude)).normalize();
            SoundFXUtils.REVERB_RAY_PROJECTED[i] = REVERB_RAY_NORMALS[i].scale((double)MAX_REVERB_DISTANCE);
        }
    }
}

