/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import com.google.common.base.MoreObjects;
import java.util.concurrent.Callable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.runtime.audio.SoundFXProcessor;
import org.orecruncher.dsurround.runtime.audio.SoundFXUtils;
import org.orecruncher.dsurround.runtime.audio.effects.Effects;
import org.orecruncher.dsurround.runtime.audio.effects.LowPassData;
import org.orecruncher.dsurround.runtime.audio.effects.SourcePropertyFloat;

public final class SourceContext
implements Callable<Void> {
    private static final int UPDATE_FEQUENCY_TICKS = 7;
    private final Object sync = new Object();
    private final LowPassData lowPass0;
    private final LowPassData lowPass1;
    private final LowPassData lowPass2;
    private final LowPassData lowPass3;
    private final LowPassData direct;
    private final SourcePropertyFloat airAbsorb;
    private final SoundFXUtils fxProcessor;
    private final int sourceId;
    private SoundInstance sound;
    private Vec3 pos;
    private SoundSource category = SoundSource.MASTER;
    private boolean isEnabled;
    private int updateCount;

    public SourceContext(int sourceId) {
        this.sourceId = sourceId;
        this.lowPass0 = new LowPassData();
        this.lowPass1 = new LowPassData();
        this.lowPass2 = new LowPassData();
        this.lowPass3 = new LowPassData();
        this.direct = new LowPassData();
        this.airAbsorb = new SourcePropertyFloat(131079, 0.0f, 0.0f, 10.0f);
        this.pos = Vec3.ZERO;
        this.fxProcessor = new SoundFXUtils(this);
    }

    public Object sync() {
        return this.sync;
    }

    public int getId() {
        return this.sourceId;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enable() {
        this.isEnabled = true;
    }

    public LowPassData getLowPass0() {
        return this.lowPass0;
    }

    public LowPassData getLowPass1() {
        return this.lowPass1;
    }

    public LowPassData getLowPass2() {
        return this.lowPass2;
    }

    public LowPassData getLowPass3() {
        return this.lowPass3;
    }

    public LowPassData getDirect() {
        return this.direct;
    }

    public SourcePropertyFloat getAirAbsorb() {
        return this.airAbsorb;
    }

    public Vec3 getPosition() {
        return this.pos;
    }

    public SoundSource getCategory() {
        return this.category;
    }

    public void attachSound(SoundInstance sound) {
        this.sound = sound;
        this.category = sound.getSource();
        this.captureState();
    }

    @Nullable
    public SoundInstance getSound() {
        return this.sound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.isEnabled()) {
            Object object = this.sync();
            synchronized (object) {
                Effects.filter0.apply(this.sourceId, this.lowPass0, 0, Effects.auxSlot0);
                Effects.filter1.apply(this.sourceId, this.lowPass1, 1, Effects.auxSlot1);
                Effects.filter2.apply(this.sourceId, this.lowPass2, 2, Effects.auxSlot2);
                Effects.filter3.apply(this.sourceId, this.lowPass3, 3, Effects.auxSlot3);
                Effects.direct.apply(this.sourceId, this.direct);
                this.airAbsorb.apply(this.sourceId);
                AudioUtilities.validate("SourceHandler::tick");
            }
        }
    }

    public boolean shouldExecute() {
        return this.updateCount++ % 7 == 0;
    }

    @Override
    public Void call() {
        this.captureState();
        this.updateImpl();
        return null;
    }

    public void exec() {
        this.captureState();
        this.updateImpl();
        this.updateCount = Randomizer.current().nextInt(7);
        this.tick();
    }

    private void updateImpl() {
        try {
            this.fxProcessor.calculate(SoundFXProcessor.getWorldContext());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void captureState() {
        if (this.sound != null) {
            this.pos = new Vec3(this.sound.getX(), this.sound.getY(), this.sound.getZ());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)AudioUtilities.debugString(this.sound)).toString();
    }
}

